/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeProvider;
import org.apache.hc.client5.http.impl.auth.CredSspScheme;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.SSLInitializationException;
import org.apache.hc.core5.ssl.TrustStrategy;

@Contract(threading=ThreadingBehavior.STATELESS)
@Experimental
public class CredSspSchemeFactory
implements AuthSchemeProvider {
    private final SSLContext sslContext;

    public CredSspSchemeFactory() {
        this(CredSspSchemeFactory.createDefaultContext());
    }

    public CredSspSchemeFactory(SSLContext sslContext) {
        this.sslContext = sslContext != null ? sslContext : CredSspSchemeFactory.createDefaultContext();
    }

    private static SSLContext createDefaultContext() throws SSLInitializationException {
        try {
            return SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new CredSspScheme(this.sslContext);
    }
}

