/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.sync;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.hc.client5.http.impl.sync.ConnectionHolder;
import org.apache.hc.client5.http.impl.sync.ResponseEntityProxy;
import org.apache.hc.client5.http.methods.CloseableHttpResponse;
import org.apache.hc.core5.annotation.NotThreadSafe;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.StatusLine;

@NotThreadSafe
class HttpResponseProxy
implements CloseableHttpResponse {
    private final HttpResponse original;
    private final ConnectionHolder connHolder;

    public HttpResponseProxy(HttpResponse original, ConnectionHolder connHolder) {
        this.original = original;
        this.connHolder = connHolder;
        ResponseEntityProxy.enchance(original, connHolder);
    }

    @Override
    public void close() throws IOException {
        if (this.connHolder != null) {
            this.connHolder.close();
        }
    }

    public StatusLine getStatusLine() {
        return this.original.getStatusLine();
    }

    public int getCode() {
        return this.original.getCode();
    }

    public void setStatusLine(StatusLine statusline) {
        this.original.setStatusLine(statusline);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.original.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.original.setStatusLine(ver, code, reason);
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.original.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.original.setReasonPhrase(reason);
    }

    public HttpEntity getEntity() {
        return (HttpEntity)this.original.getEntity();
    }

    public void setEntity(HttpEntity entity) {
        this.original.setEntity((Object)entity);
    }

    public Locale getLocale() {
        return this.original.getLocale();
    }

    public void setLocale(Locale loc) {
        this.original.setLocale(loc);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.original.getProtocolVersion();
    }

    public int containsHeaders(String name) {
        return this.original.containsHeaders(name);
    }

    public boolean containsHeader(String name) {
        return this.original.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.original.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.original.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.original.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.original.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.original.addHeader(header);
    }

    public void addHeader(String name, Object value) {
        this.original.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.original.setHeader(header);
    }

    public void setHeader(String name, Object value) {
        this.original.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.original.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.original.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.original.removeHeaders(name);
    }

    public Iterator<Header> headerIterator() {
        return this.original.headerIterator();
    }

    public Iterator<Header> headerIterator(String name) {
        return this.original.headerIterator(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpResponseProxy{");
        sb.append(this.original);
        sb.append('}');
        return sb.toString();
    }
}

