/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthSchemeProvider;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.AuthenticationStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Immutable;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Immutable
public class DefaultAuthenticationStrategy
implements AuthenticationStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final DefaultAuthenticationStrategy INSTANCE = new DefaultAuthenticationStrategy();
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("Negotiate", "Kerberos", "NTLM", "Digest", "Basic"));

    @Override
    public List<AuthScheme> select(ChallengeType challengeType, Map<String, AuthChallenge> challenges, HttpContext context) {
        Collection<String> authPrefs;
        Args.notNull((Object)((Object)challengeType), (String)"ChallengeType");
        Args.notNull(challenges, (String)"Map of auth challenges");
        Args.notNull((Object)context, (String)"HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        ArrayList<AuthScheme> options = new ArrayList<AuthScheme>();
        Lookup<AuthSchemeProvider> registry = clientContext.getAuthSchemeRegistry();
        if (registry == null) {
            this.log.debug((Object)"Auth scheme registry not set in the context");
            return options;
        }
        RequestConfig config = clientContext.getRequestConfig();
        Collection<String> collection = authPrefs = challengeType == ChallengeType.TARGET ? config.getTargetPreferredAuthSchemes() : config.getProxyPreferredAuthSchemes();
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication schemes in the order of preference: " + authPrefs));
        }
        for (String id : authPrefs) {
            AuthChallenge challenge = challenges.get(id.toLowerCase(Locale.ROOT));
            if (challenge != null) {
                AuthSchemeProvider authSchemeProvider = (AuthSchemeProvider)registry.lookup(id);
                if (authSchemeProvider == null) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)("Authentication scheme " + id + " not supported"));
                    continue;
                }
                AuthScheme authScheme = authSchemeProvider.create(context);
                options.add(authScheme);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Challenge for " + id + " authentication scheme not available"));
        }
        return options;
    }
}

