/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.core5.annotation.NotThreadSafe;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.config.MessageConstraints;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.util.CharArrayBuffer;

@NotThreadSafe
public class LenientHttpResponseParser
extends DefaultHttpResponseParser {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public LenientHttpResponseParser(LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(lineParser, responseFactory, constraints);
    }

    public LenientHttpResponseParser(MessageConstraints constraints) {
        this(null, null, constraints);
    }

    protected HttpResponse createMessage(CharArrayBuffer buffer) throws IOException {
        try {
            return super.createMessage(buffer);
        }
        catch (HttpException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Garbage in response: " + buffer.toString()));
            }
            return null;
        }
    }
}

