/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.protocol.AuthenticationStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.CharArrayBuffer;

public class HttpAuthenticator {
    private final Log log;
    private final AuthChallengeParser parser;

    public HttpAuthenticator(Log log) {
        this.log = log != null ? log : LogFactory.getLog(this.getClass());
        this.parser = new AuthChallengeParser();
    }

    public HttpAuthenticator() {
        this(null);
    }

    public boolean isChallenged(HttpHost host, ChallengeType challengeType, HttpResponse response, AuthExchange authExchange, HttpContext context) {
        int challengeCode;
        switch (challengeType) {
            case TARGET: {
                challengeCode = 401;
                break;
            }
            case PROXY: {
                challengeCode = 407;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected challenge type: " + (Object)((Object)challengeType));
            }
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        if (response.getStatusLine().getStatusCode() == challengeCode) {
            this.log.debug((Object)"Authentication required");
            if (authExchange.getState() == AuthExchange.State.SUCCESS) {
                this.clearCache(host, clientContext);
            }
            return true;
        }
        switch (authExchange.getState()) {
            case CHALLENGED: 
            case HANDSHAKE: {
                this.log.debug((Object)"Authentication succeeded");
                authExchange.setState(AuthExchange.State.SUCCESS);
                this.updateCache(host, authExchange.getAuthScheme(), clientContext);
                break;
            }
            case SUCCESS: {
                break;
            }
            default: {
                authExchange.setState(AuthExchange.State.UNCHALLENGED);
            }
        }
        return false;
    }

    public boolean prepareAuthResponse(HttpHost host, ChallengeType challengeType, HttpResponse response, AuthenticationStrategy authStrategy, AuthExchange authExchange, HttpContext context) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(host.toHostString() + " requested authentication"));
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Header[] headers = response.getHeaders(challengeType == ChallengeType.PROXY ? "Proxy-Authenticate" : "WWW-Authenticate");
        HashMap<String, AuthChallenge> challengeMap = new HashMap<String, AuthChallenge>();
        for (Header header : headers) {
            List<AuthChallenge> authChallenges;
            int pos;
            CharArrayBuffer buffer;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s = header.getValue();
                if (s == null) continue;
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            ParserCursor cursor = new ParserCursor(pos, buffer.length());
            try {
                authChallenges = this.parser.parse((CharSequence)buffer, cursor);
            }
            catch (ParseException ex) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)("Malformed challenge: " + header.getValue()));
                continue;
            }
            for (AuthChallenge authChallenge : authChallenges) {
                String scheme = authChallenge.getScheme().toLowerCase(Locale.ROOT);
                if (challengeMap.containsKey(scheme)) continue;
                challengeMap.put(scheme, authChallenge);
            }
        }
        if (challengeMap.isEmpty()) {
            this.log.debug((Object)"Response contains no valid authentication challenges");
            this.clearCache(host, clientContext);
            authExchange.reset();
            return false;
        }
        switch (authExchange.getState()) {
            case FAILURE: {
                return false;
            }
            case SUCCESS: {
                authExchange.reset();
                break;
            }
            case CHALLENGED: 
            case HANDSHAKE: {
                Asserts.notNull((Object)authExchange.getAuthScheme(), (String)"AuthScheme");
            }
            case UNCHALLENGED: {
                AuthScheme authScheme = authExchange.getAuthScheme();
                if (authScheme == null) break;
                String id = authScheme.getName();
                AuthChallenge challenge = (AuthChallenge)challengeMap.get(id.toLowerCase(Locale.ROOT));
                if (challenge != null) {
                    this.log.debug((Object)"Authorization challenge processed");
                    try {
                        authScheme.processChallenge(challenge, context);
                    }
                    catch (MalformedChallengeException ex) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)ex.getMessage());
                        }
                        this.clearCache(host, clientContext);
                        authExchange.reset();
                        return false;
                    }
                    if (authScheme.isChallengeComplete()) {
                        this.log.debug((Object)"Authentication failed");
                        this.clearCache(host, clientContext);
                        authExchange.reset();
                        authExchange.setState(AuthExchange.State.FAILURE);
                        return false;
                    }
                    authExchange.setState(AuthExchange.State.HANDSHAKE);
                    return true;
                }
                authExchange.reset();
            }
        }
        List<AuthScheme> preferredSchemes = authStrategy.select(challengeType, challengeMap, context);
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            this.log.debug((Object)"Credentials provider not set in the context");
            return false;
        }
        LinkedList<AuthScheme> authOptions = new LinkedList<AuthScheme>();
        for (AuthScheme authScheme : preferredSchemes) {
            try {
                String id = authScheme.getName();
                AuthChallenge challenge = (AuthChallenge)challengeMap.get(id.toLowerCase(Locale.ROOT));
                authScheme.processChallenge(challenge, context);
                if (!authScheme.isResponseReady(host, credsProvider, context)) continue;
                authOptions.add(authScheme);
            }
            catch (AuthenticationException | MalformedChallengeException ex) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)ex.getMessage());
            }
        }
        if (!authOptions.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Selected authentication options: " + authOptions));
            }
            authExchange.reset();
            authExchange.setState(AuthExchange.State.CHALLENGED);
            authExchange.setOptions(authOptions);
            return true;
        }
        return false;
    }

    public void addAuthResponse(HttpHost host, ChallengeType challengeType, HttpRequest request, AuthExchange authExchange, HttpContext context) throws HttpException, IOException {
        block14: {
            AuthScheme authScheme = authExchange.getAuthScheme();
            switch (authExchange.getState()) {
                case FAILURE: {
                    return;
                }
                case SUCCESS: {
                    Asserts.notNull((Object)authScheme, (String)"AuthScheme");
                    if (!authScheme.isConnectionBased()) break;
                    return;
                }
                case HANDSHAKE: {
                    Asserts.notNull((Object)authScheme, (String)"AuthScheme");
                    break;
                }
                case CHALLENGED: {
                    Queue<AuthScheme> authOptions = authExchange.getAuthOptions();
                    if (authOptions != null) {
                        while (!authOptions.isEmpty()) {
                            authScheme = authOptions.remove();
                            authExchange.select(authScheme);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Generating response to an authentication challenge using " + authScheme.getName() + " scheme"));
                            }
                            try {
                                String authResponse = authScheme.generateAuthResponse(host, request, context);
                                BasicHeader header = new BasicHeader(challengeType == ChallengeType.TARGET ? "Authorization" : "Proxy-Authorization", (Object)authResponse);
                                request.addHeader((Header)header);
                                break;
                            }
                            catch (AuthenticationException ex) {
                                if (!this.log.isWarnEnabled()) continue;
                                this.log.warn((Object)(authScheme + " authentication error: " + ex.getMessage()));
                            }
                        }
                        return;
                    }
                    Asserts.notNull((Object)authScheme, (String)"AuthScheme");
                }
            }
            if (authScheme != null) {
                try {
                    String authResponse = authScheme.generateAuthResponse(host, request, context);
                    BasicHeader header = new BasicHeader(challengeType == ChallengeType.TARGET ? "Authorization" : "Proxy-Authorization", (Object)authResponse);
                    request.addHeader((Header)header);
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block14;
                    this.log.error((Object)(authScheme + " authentication error: " + ex.getMessage()));
                }
            }
        }
    }

    private boolean isCachable(AuthScheme authScheme) {
        String schemeName = authScheme.getName();
        return schemeName.equalsIgnoreCase("Basic") || schemeName.equalsIgnoreCase("Digest");
    }

    private void updateCache(HttpHost host, AuthScheme authScheme, HttpClientContext clientContext) {
        if (this.isCachable(authScheme)) {
            AuthCache authCache = clientContext.getAuthCache();
            if (authCache == null) {
                authCache = new BasicAuthCache();
                clientContext.setAuthCache(authCache);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Caching '" + authScheme.getName() + "' auth scheme for " + host));
            }
            authCache.put(host, authScheme);
        }
    }

    private void clearCache(HttpHost host, HttpClientContext clientContext) {
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Clearing cached auth scheme for " + host));
            }
            authCache.remove(host);
        }
    }
}

