/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.annotation.Immutable;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.Args;

@Immutable
public final class AuthChallenge {
    private final String scheme;
    private final String value;
    private final List<NameValuePair> params;

    public AuthChallenge(String scheme, String value, List<? extends NameValuePair> params) {
        Args.notNull((Object)scheme, (String)"Auth scheme");
        this.scheme = scheme;
        this.value = value;
        this.params = params != null ? Collections.unmodifiableList(new ArrayList<NameValuePair>(params)) : null;
    }

    public AuthChallenge(String scheme, NameValuePair ... params) {
        this(scheme, null, Arrays.asList(params));
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getValue() {
        return this.value;
    }

    public List<NameValuePair> getParams() {
        return this.params;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.scheme).append(" ");
        if (this.value != null) {
            buffer.append(this.value);
        } else if (this.params != null) {
            buffer.append(this.params);
        }
        return buffer.toString();
    }
}

