/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.osgi.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hc.client5.http.osgi.impl.HostMatcher;
import org.apache.hc.client5.http.osgi.services.TrustedHostsConfiguration;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;

final class RelaxedLayeredConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    private final TrustedHostsConfiguration trustedHostsConfiguration;
    private final LayeredConnectionSocketFactory defaultSocketFactory;

    public RelaxedLayeredConnectionSocketFactory(TrustedHostsConfiguration trustedHostsConfiguration, LayeredConnectionSocketFactory defaultSocketFactory) {
        this.trustedHostsConfiguration = trustedHostsConfiguration;
        this.defaultSocketFactory = defaultSocketFactory;
    }

    @Override
    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        if (this.trustedHostsConfiguration.isEnabled()) {
            if (this.trustedHostsConfiguration.trustAll()) {
                return socket;
            }
            for (String trustedHost : this.trustedHostsConfiguration.getTrustedHosts()) {
                if (!HostMatcher.HostMatcherFactory.createMatcher(trustedHost).matches(target)) continue;
                return socket;
            }
        }
        return this.defaultSocketFactory.createLayeredSocket(socket, target, port, context);
    }

    @Override
    public Socket createSocket(HttpContext context) throws IOException {
        return this.defaultSocketFactory.createSocket(context);
    }

    @Override
    public Socket connectSocket(TimeValue connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        return this.defaultSocketFactory.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
    }
}

