/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.osgi.impl;

import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.osgi.impl.HttpClientBuilderConfigurator;
import org.apache.hc.client5.http.osgi.impl.HttpProxyConfigurationActivator;
import org.apache.hc.client5.http.osgi.services.HttpClientBuilderFactory;

final class OSGiClientBuilderFactory
implements HttpClientBuilderFactory {
    private final HttpClientBuilderConfigurator configurator;
    private final HttpProxyConfigurationActivator.HttpClientTracker httpClientTracker;

    OSGiClientBuilderFactory(HttpClientBuilderConfigurator configurator, HttpProxyConfigurationActivator.HttpClientTracker httpClientTracker) {
        this.configurator = configurator;
        this.httpClientTracker = httpClientTracker;
    }

    @Override
    public HttpClientBuilder newBuilder() {
        return this.configurator.configure(new HttpClientBuilder(){

            @Override
            public CloseableHttpClient build() {
                CloseableHttpClient client = super.build();
                OSGiClientBuilderFactory.this.httpClientTracker.track(client);
                return client;
            }
        });
    }
}

