/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public class Http2AsyncMainClientExec
implements AsyncExecChainHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(final HttpRequest request, final AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        String exchangeId = scope.exchangeId;
        CancellableDependency operation = scope.cancellableDependency;
        HttpClientContext clientContext = scope.clientContext;
        final AsyncExecRuntime execRuntime = scope.execRuntime;
        if (this.log.isDebugEnabled()) {
            this.log.debug(exchangeId + ": executing " + new RequestLine(request));
        }
        AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){
            private final AtomicReference<AsyncDataConsumer> entityConsumerRef = new AtomicReference<Object>(null);

            public void releaseResources() {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.releaseResources();
                }
            }

            public void failed(Exception cause) {
                execRuntime.markConnectionNonReusable();
                asyncExecCallback.failed(cause);
            }

            public void cancel() {
                this.failed(new InterruptedIOException());
            }

            public void produceRequest(RequestChannel channel, HttpContext context) throws HttpException, IOException {
                channel.sendRequest(request, (EntityDetails)entityProducer, context);
            }

            public int available() {
                return entityProducer.available();
            }

            public void produce(DataStreamChannel channel) throws IOException {
                entityProducer.produce(channel);
            }

            public void consumeInformation(HttpResponse response, HttpContext context) throws HttpException, IOException {
            }

            public void consumeResponse(HttpResponse response, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
                this.entityConsumerRef.set(asyncExecCallback.handleResponse(response, entityDetails));
                if (entityDetails == null) {
                    execRuntime.validateConnection();
                    asyncExecCallback.completed();
                }
            }

            public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    entityConsumer.updateCapacity(capacityChannel);
                } else {
                    capacityChannel.update(Integer.MAX_VALUE);
                }
            }

            public int consume(ByteBuffer src) throws IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.get();
                if (entityConsumer != null) {
                    return entityConsumer.consume(src);
                }
                return Integer.MAX_VALUE;
            }

            public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                AsyncDataConsumer entityConsumer = this.entityConsumerRef.getAndSet(null);
                if (entityConsumer != null) {
                    entityConsumer.streamEnd(trailers);
                } else {
                    execRuntime.validateConnection();
                }
                asyncExecCallback.completed();
            }
        };
        if (this.log.isDebugEnabled()) {
            operation.setDependency(execRuntime.execute(new LoggingAsyncClientExchangeHandler(this.log, exchangeId, internalExchangeHandler), clientContext));
        } else {
            operation.setDependency(execRuntime.execute(internalExchangeHandler, clientContext));
        }
    }
}

