/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.fluent.Content;
import org.apache.hc.client5.http.fluent.ContentResponseHandler;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class Response {
    private final ClassicHttpResponse response;
    private boolean consumed;

    Response(ClassicHttpResponse response) {
        this.response = response;
    }

    private void assertNotConsumed() {
        if (this.consumed) {
            throw new IllegalStateException("Response content has been already consumed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        if (this.consumed) {
            return;
        }
        try {
            HttpEntity entity = this.response.getEntity();
            InputStream content = entity.getContent();
            if (content != null) {
                content.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.consumed = true;
        }
    }

    public void discardContent() {
        this.dispose();
    }

    public <T> T handleResponse(HttpClientResponseHandler<T> handler) throws IOException {
        this.assertNotConsumed();
        try {
            Object object = handler.handleResponse(this.response);
            return (T)object;
        }
        catch (HttpException ex) {
            throw new ClientProtocolException(ex);
        }
        finally {
            this.dispose();
        }
    }

    public Content returnContent() throws IOException {
        return this.handleResponse(new ContentResponseHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse returnResponse() throws IOException {
        this.assertNotConsumed();
        try {
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)entity));
                ContentType contentType = EntityUtils.getContentTypeOrDefault((HttpEntity)entity);
                byteArrayEntity.setContentType(contentType.toString());
                this.response.setEntity((HttpEntity)byteArrayEntity);
            }
            ClassicHttpResponse classicHttpResponse = this.response;
            return classicHttpResponse;
        }
        finally {
            this.consumed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContent(File file) throws IOException {
        this.assertNotConsumed();
        int status = this.response.getCode();
        if (status >= 300) {
            throw new HttpResponseException(status, this.response.getReasonPhrase());
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            HttpEntity entity = this.response.getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)out);
            }
        }
        finally {
            this.consumed = true;
        }
    }
}

