/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.InternalByteArrayEntity;
import org.apache.hc.client5.http.fluent.InternalFileEntity;
import org.apache.hc.client5.http.fluent.InternalHttpRequest;
import org.apache.hc.client5.http.fluent.InternalInputStreamEntity;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.sync.CloseableHttpClient;
import org.apache.hc.client5.http.methods.Configurable;
import org.apache.hc.client5.http.methods.HttpUriRequest;
import org.apache.hc.client5.http.utils.URLEncodedUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.entity.ContentType;
import org.apache.hc.core5.http.protocol.HttpContext;

public class Request {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final Locale DATE_LOCALE = Locale.US;
    public static final TimeZone TIME_ZONE = TimeZone.getTimeZone("GMT");
    private final InternalHttpRequest request;
    private Boolean useExpectContinue;
    private Integer socketTmeout;
    private Integer connectTimeout;
    private HttpHost proxy;
    private SimpleDateFormat dateFormatter;

    public static Request create(String methodName, String uri) {
        return new Request(new InternalHttpRequest(methodName, URI.create(uri)));
    }

    public static Request create(String methodName, URI uri) {
        return new Request(new InternalHttpRequest(methodName, uri));
    }

    public static Request Get(URI uri) {
        return new Request(new InternalHttpRequest("GET", uri));
    }

    public static Request Get(String uri) {
        return new Request(new InternalHttpRequest("GET", URI.create(uri)));
    }

    public static Request Head(URI uri) {
        return new Request(new InternalHttpRequest("HEAD", uri));
    }

    public static Request Head(String uri) {
        return new Request(new InternalHttpRequest("HEAD", URI.create(uri)));
    }

    public static Request Post(URI uri) {
        return new Request(new InternalHttpRequest("POST", uri));
    }

    public static Request Post(String uri) {
        return new Request(new InternalHttpRequest("POST", URI.create(uri)));
    }

    public static Request Patch(URI uri) {
        return new Request(new InternalHttpRequest("PATCH", uri));
    }

    public static Request Patch(String uri) {
        return new Request(new InternalHttpRequest("PATCH", URI.create(uri)));
    }

    public static Request Put(URI uri) {
        return new Request(new InternalHttpRequest("PUT", uri));
    }

    public static Request Put(String uri) {
        return new Request(new InternalHttpRequest("PUT", URI.create(uri)));
    }

    public static Request Trace(URI uri) {
        return new Request(new InternalHttpRequest("TRACE", uri));
    }

    public static Request Trace(String uri) {
        return new Request(new InternalHttpRequest("TRACE", URI.create(uri)));
    }

    public static Request Delete(URI uri) {
        return new Request(new InternalHttpRequest("DELETE", uri));
    }

    public static Request Delete(String uri) {
        return new Request(new InternalHttpRequest("DELETE", URI.create(uri)));
    }

    public static Request Options(URI uri) {
        return new Request(new InternalHttpRequest("OPTIONS", uri));
    }

    public static Request Options(String uri) {
        return new Request(new InternalHttpRequest("OPTIONS", URI.create(uri)));
    }

    Request(InternalHttpRequest request) {
        this.request = request;
    }

    HttpResponse internalExecute(CloseableHttpClient client, HttpContext localContext) throws IOException {
        RequestConfig.Builder builder = client instanceof Configurable ? RequestConfig.copy((RequestConfig)((Configurable)client).getConfig()) : RequestConfig.custom();
        if (this.useExpectContinue != null) {
            builder.setExpectContinueEnabled(this.useExpectContinue.booleanValue());
        }
        if (this.socketTmeout != null) {
            builder.setSocketTimeout(this.socketTmeout.intValue());
        }
        if (this.connectTimeout != null) {
            builder.setConnectTimeout(this.connectTimeout.intValue());
        }
        if (this.proxy != null) {
            builder.setProxy(this.proxy);
        }
        RequestConfig config = builder.build();
        this.request.setConfig(config);
        return client.execute((HttpUriRequest)this.request, localContext);
    }

    public Response execute() throws IOException {
        return new Response(this.internalExecute(Executor.CLIENT, null));
    }

    public void abort() throws UnsupportedOperationException {
        this.request.abort();
    }

    public Request addHeader(Header header) {
        this.request.addHeader(header);
        return this;
    }

    public Request setHeader(Header header) {
        this.request.setHeader(header);
        return this;
    }

    public Request addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public Request setHeader(String name, String value) {
        this.request.setHeader(name, value);
        return this;
    }

    public Request removeHeader(Header header) {
        this.request.removeHeader(header);
        return this;
    }

    public Request removeHeaders(String name) {
        this.request.removeHeaders(name);
        return this;
    }

    public Request setHeaders(Header ... headers) {
        this.request.setHeaders(headers);
        return this;
    }

    public Request setCacheControl(String cacheControl) {
        this.request.setHeader("Cache-Control", cacheControl);
        return this;
    }

    private SimpleDateFormat getDateFormat() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
            this.dateFormatter.setTimeZone(TIME_ZONE);
        }
        return this.dateFormatter;
    }

    public Request setDate(Date date) {
        this.request.setHeader("Date", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfModifiedSince(Date date) {
        this.request.setHeader("If-Modified-Since", this.getDateFormat().format(date));
        return this;
    }

    public Request setIfUnmodifiedSince(Date date) {
        this.request.setHeader("If-Unmodified-Since", this.getDateFormat().format(date));
        return this;
    }

    public Request version(HttpVersion version) {
        this.request.setProtocolVersion((ProtocolVersion)version);
        return this;
    }

    public Request useExpectContinue() {
        this.useExpectContinue = Boolean.TRUE;
        return this;
    }

    public Request userAgent(String agent) {
        this.request.setHeader("User-Agent", agent);
        return this;
    }

    public Request socketTimeout(int timeout) {
        this.socketTmeout = timeout;
        return this;
    }

    public Request connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public Request viaProxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public Request viaProxy(String proxy) {
        this.proxy = HttpHost.create((String)proxy);
        return this;
    }

    public Request body(HttpEntity entity) {
        this.request.setEntity(entity);
        return this;
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams, Charset charset) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : formParams) {
            paramList.add(nameValuePair);
        }
        ContentType contentType = ContentType.create((String)"application/x-www-form-urlencoded", (Charset)charset);
        String string = URLEncodedUtils.format(paramList, (String)(charset != null ? charset.name() : null));
        return this.bodyString(string, contentType);
    }

    public Request bodyForm(Iterable<? extends NameValuePair> formParams) {
        return this.bodyForm(formParams, StandardCharsets.ISO_8859_1);
    }

    public Request bodyForm(NameValuePair ... formParams) {
        return this.bodyForm(Arrays.asList(formParams), StandardCharsets.ISO_8859_1);
    }

    public Request bodyString(String s, ContentType contentType) {
        Charset charset = contentType != null ? contentType.getCharset() : null;
        byte[] raw = charset != null ? s.getBytes(charset) : s.getBytes();
        return this.body((HttpEntity)new InternalByteArrayEntity(raw, contentType));
    }

    public Request bodyFile(File file, ContentType contentType) {
        return this.body((HttpEntity)new InternalFileEntity(file, contentType));
    }

    public Request bodyByteArray(byte[] b) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b));
    }

    public Request bodyByteArray(byte[] b, ContentType contentType) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b, contentType));
    }

    public Request bodyByteArray(byte[] b, int off, int len) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b, off, len));
    }

    public Request bodyByteArray(byte[] b, int off, int len, ContentType contentType) {
        return this.body((HttpEntity)new InternalByteArrayEntity(b, off, len, contentType));
    }

    public Request bodyStream(InputStream instream) {
        return this.body((HttpEntity)new InternalInputStreamEntity(instream, -1L, null));
    }

    public Request bodyStream(InputStream instream, ContentType contentType) {
        return this.body((HttpEntity)new InternalInputStreamEntity(instream, -1L, contentType));
    }

    public String toString() {
        return this.request.getRequestLine().toString();
    }
}

