/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.http.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.entity.ContentType;
import org.apache.hc.core5.util.Args;

class InternalInputStreamEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    public InternalInputStreamEntity(InputStream instream, long length, ContentType contentType) {
        this.content = (InputStream)Args.notNull((Object)instream, (String)"Source input stream");
        this.length = length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        return this.content;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        block16: {
            Args.notNull((Object)outstream, (String)"Output stream");
            try (InputStream instream = this.content;){
                int l;
                byte[] buffer = new byte[4096];
                if (this.length < 0L) {
                    int l2;
                    while ((l2 = instream.read(buffer)) != -1) {
                        outstream.write(buffer, 0, l2);
                    }
                    break block16;
                }
                for (long remaining = this.length; remaining > 0L; remaining -= (long)l) {
                    l = instream.read(buffer, 0, (int)Math.min(4096L, remaining));
                    if (l == -1) {
                        break;
                    }
                    outstream.write(buffer, 0, l);
                }
            }
        }
    }

    public boolean isStreaming() {
        return true;
    }
}

