/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.methods.Configurable;
import org.apache.hc.client5.http.methods.HttpExecutionAware;
import org.apache.hc.client5.http.methods.HttpUriRequest;
import org.apache.hc.core5.annotation.NotThreadSafe;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.RequestLine;
import org.apache.hc.core5.http.message.AbstractHttpMessage;
import org.apache.hc.core5.http.message.BasicRequestLine;
import org.apache.hc.core5.util.Args;

@NotThreadSafe
class InternalHttpRequest
extends AbstractHttpMessage
implements HttpUriRequest,
HttpExecutionAware,
Configurable {
    private final String method;
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;
    private final AtomicBoolean aborted;
    private final AtomicReference<Cancellable> cancellableRef;

    InternalHttpRequest(String method, URI requestURI) {
        Args.notBlank((CharSequence)method, (String)"Method");
        Args.notNull((Object)requestURI, (String)"Request URI");
        this.method = method;
        this.uri = requestURI;
        this.aborted = new AtomicBoolean(false);
        this.cancellableRef = new AtomicReference<Object>(null);
    }

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpVersion.HTTP_1_1;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.uri;
    }

    public void abort() throws UnsupportedOperationException {
        Cancellable cancellable;
        if (this.aborted.compareAndSet(false, true) && (cancellable = (Cancellable)this.cancellableRef.getAndSet(null)) != null) {
            cancellable.cancel();
        }
    }

    public boolean isAborted() {
        return this.aborted.get();
    }

    public void setCancellable(Cancellable cancellable) {
        if (!this.aborted.get()) {
            this.cancellableRef.set(cancellable);
        }
    }

    public RequestLine getRequestLine() {
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            uritext = uriCopy.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(this.getMethod(), uritext, ver);
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

