/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.http.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.entity.ContentType;
import org.apache.hc.core5.util.Args;

class InternalFileEntity
extends AbstractHttpEntity
implements Cloneable {
    private final File file;

    public InternalFileEntity(File file, ContentType contentType) {
        this.file = (File)Args.notNull((Object)file, (String)"File");
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.file.length();
    }

    public InputStream getContent() throws IOException {
        return new FileInputStream(this.file);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        try (FileInputStream instream = new FileInputStream(this.file);){
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)instream).read(tmp)) != -1) {
                outstream.write(tmp, 0, l);
            }
            outstream.flush();
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

