/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.fluent;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.sync.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.sync.CloseableHttpClient;
import org.apache.hc.client5.http.impl.sync.HttpClientBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLInitializationException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;

public class Executor {
    static final PoolingHttpClientConnectionManager CONNMGR;
    static final CloseableHttpClient CLIENT;
    private final CloseableHttpClient httpclient;
    private final AuthCache authCache;
    private volatile CredentialsStore credentialsStore;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(CloseableHttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : CLIENT);
    }

    Executor(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
        this.authCache = new BasicAuthCache();
    }

    public Executor use(CredentialsStore credentialsStore) {
        this.credentialsStore = credentialsStore;
        return this;
    }

    public Executor auth(AuthScope authScope, Credentials creds) {
        if (this.credentialsStore == null) {
            this.credentialsStore = new BasicCredentialsProvider();
        }
        this.credentialsStore.setCredentials(authScope, creds);
        return this;
    }

    public Executor auth(HttpHost host, Credentials creds) {
        AuthScope authScope = host != null ? new AuthScope(host.getHostName(), host.getPort()) : AuthScope.ANY;
        return this.auth(authScope, creds);
    }

    public Executor auth(String host, Credentials creds) {
        return this.auth(HttpHost.create((String)host), creds);
    }

    public Executor authPreemptive(HttpHost host) {
        Credentials credentials;
        if (this.credentialsStore != null && (credentials = this.credentialsStore.getCredentials(new AuthScope(host))) == null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(host, (AuthScheme)basicScheme);
        }
        return this;
    }

    public Executor authPreemptive(String host) {
        return this.authPreemptive(HttpHost.create((String)host));
    }

    public Executor authPreemptiveProxy(HttpHost proxy) {
        Credentials credentials;
        if (this.credentialsStore != null && (credentials = this.credentialsStore.getCredentials(new AuthScope(proxy))) == null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(proxy, (AuthScheme)basicScheme);
        }
        return this;
    }

    public Executor authPreemptiveProxy(String proxy) {
        return this.authPreemptiveProxy(HttpHost.create((String)proxy));
    }

    public Executor auth(Credentials cred) {
        return this.auth(AuthScope.ANY, cred);
    }

    public Executor auth(String username, char[] password) {
        return this.auth((Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(String username, char[] password, String workstation, String domain) {
        return this.auth((Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor auth(HttpHost host, String username, char[] password) {
        return this.auth(host, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(HttpHost host, String username, char[] password, String workstation, String domain) {
        return this.auth(host, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        if (this.credentialsStore != null) {
            this.credentialsStore.clear();
        }
        return this;
    }

    public Executor use(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        if (this.cookieStore != null) {
            this.cookieStore.clear();
        }
        return this;
    }

    public Response execute(Request request) throws IOException {
        HttpClientContext localContext = HttpClientContext.create();
        if (this.credentialsStore != null) {
            localContext.setAttribute("http.auth.credentials-provider", (Object)this.credentialsStore);
        }
        if (this.authCache != null) {
            localContext.setAttribute("http.auth.auth-cache", (Object)this.authCache);
        }
        if (this.cookieStore != null) {
            localContext.setAttribute("http.cookie-store", (Object)this.cookieStore);
        }
        return new Response(request.internalExecute(this.httpclient, (HttpContext)localContext));
    }

    public static void closeIdleConnections() {
        CONNMGR.closeIdleConnections(0L, TimeUnit.MICROSECONDS);
    }

    static {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException ex) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, null, null);
                ssl = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (SecurityException | KeyManagementException | NoSuchAlgorithmException exception) {
                // empty catch block
            }
        }
        Registry sfr = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory())).build();
        CONNMGR = new PoolingHttpClientConnectionManager(sfr);
        CONNMGR.setDefaultMaxPerRoute(100);
        CONNMGR.setMaxTotal(200);
        CONNMGR.setValidateAfterInactivity(1000);
        CLIENT = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)CONNMGR).build();
    }
}

