/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.value;

import org.apache.htrace.msgpack.core.MessageFormat;

public enum ValueType {
    NIL(false, false),
    BOOLEAN(false, false),
    INTEGER(true, false),
    FLOAT(true, false),
    STRING(false, true),
    BINARY(false, true),
    ARRAY(false, false),
    MAP(false, false),
    EXTENDED(false, true);

    private final boolean numberType;
    private final boolean rawType;
    private final int bitMask;

    private ValueType(boolean bl, boolean bl2) {
        this.numberType = bl;
        this.rawType = bl2;
        this.bitMask = 1 << this.ordinal();
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public boolean isTypeOf(int n) {
        return (this.bitMask & n) != 0;
    }

    public boolean isNilType() {
        return this == NIL;
    }

    public boolean isBooleanType() {
        return this == BOOLEAN;
    }

    public boolean isNumberType() {
        return this.numberType;
    }

    public boolean isIntegerType() {
        return this == INTEGER;
    }

    public boolean isFloatType() {
        return this == FLOAT;
    }

    public boolean isRawType() {
        return this.rawType;
    }

    public boolean isStringType() {
        return this == STRING;
    }

    public boolean isBinaryType() {
        return this == BINARY;
    }

    public boolean isArrayType() {
        return this == ARRAY;
    }

    public boolean isMapType() {
        return this == MAP;
    }

    public boolean isExtendedType() {
        return this == EXTENDED;
    }

    public static ValueType valueOf(byte by) {
        return MessageFormat.valueOf(by).getValueType();
    }

    public String toTypeName() {
        return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
    }
}

