/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.core.buffer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

class DirectBufferAccess {
    static Method mGetAddress;
    static Method mCleaner;
    static Method mClean;
    static Constructor byteBufferConstructor;
    static Class<?> directByteBufferClass;
    static DirectBufferConstructorType directBufferConstructorType;
    static Method memoryBlockWrapFromJni;

    DirectBufferAccess() {
    }

    static long getAddress(Object object) {
        try {
            return (Long)mGetAddress.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    static void clean(Object object) {
        try {
            Object object2 = mCleaner.invoke(object, new Object[0]);
            mClean.invoke(object2, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static boolean isDirectByteBufferInstance(Object object) {
        return directByteBufferClass.isInstance(object);
    }

    static ByteBuffer newByteBuffer(long l, int n, int n2, ByteBuffer byteBuffer) {
        try {
            switch (directBufferConstructorType) {
                case ARGS_LONG_INT_REF: {
                    return (ByteBuffer)byteBufferConstructor.newInstance(l + (long)n, n2, byteBuffer);
                }
                case ARGS_LONG_INT: {
                    return (ByteBuffer)byteBufferConstructor.newInstance(l + (long)n, n2);
                }
                case ARGS_INT_INT: {
                    return (ByteBuffer)byteBufferConstructor.newInstance((int)l + n, n2);
                }
                case ARGS_MB_INT_INT: {
                    return (ByteBuffer)byteBufferConstructor.newInstance(memoryBlockWrapFromJni.invoke(null, l + (long)n, n2), n2, 0);
                }
            }
            throw new IllegalStateException("Unexpected value");
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static {
        try {
            directByteBufferClass = ClassLoader.getSystemClassLoader().loadClass("java.nio.DirectByteBuffer");
            Constructor<?> constructor = null;
            DirectBufferConstructorType directBufferConstructorType = null;
            Method method = null;
            try {
                constructor = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
                directBufferConstructorType = DirectBufferConstructorType.ARGS_LONG_INT_REF;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    constructor = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                    directBufferConstructorType = DirectBufferConstructorType.ARGS_LONG_INT;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        constructor = directByteBufferClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
                        directBufferConstructorType = DirectBufferConstructorType.ARGS_INT_INT;
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        Class<?> clazz = Class.forName("java.nio.MemoryBlock");
                        method = clazz.getDeclaredMethod("wrapFromJni", Integer.TYPE, Long.TYPE);
                        method.setAccessible(true);
                        constructor = directByteBufferClass.getDeclaredConstructor(clazz, Integer.TYPE, Integer.TYPE);
                        directBufferConstructorType = DirectBufferConstructorType.ARGS_MB_INT_INT;
                    }
                }
            }
            byteBufferConstructor = constructor;
            DirectBufferAccess.directBufferConstructorType = directBufferConstructorType;
            memoryBlockWrapFromJni = method;
            if (byteBufferConstructor == null) {
                throw new RuntimeException("Constructor of DirectByteBuffer is not found");
            }
            byteBufferConstructor.setAccessible(true);
            mGetAddress = directByteBufferClass.getDeclaredMethod("address", new Class[0]);
            mGetAddress.setAccessible(true);
            mCleaner = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
            mCleaner.setAccessible(true);
            mClean = mCleaner.getReturnType().getDeclaredMethod("clean", new Class[0]);
            mClean.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static enum DirectBufferConstructorType {
        ARGS_LONG_INT_REF,
        ARGS_LONG_INT,
        ARGS_INT_INT,
        ARGS_MB_INT_INT;

    }
}

