/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.msgpack.core.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.htrace.msgpack.core.Preconditions;
import org.apache.htrace.msgpack.core.buffer.MessageBuffer;
import org.apache.htrace.msgpack.core.buffer.MessageBufferOutput;

public class ChannelBufferOutput
implements MessageBufferOutput {
    private WritableByteChannel channel;
    private MessageBuffer buffer;

    public ChannelBufferOutput(WritableByteChannel writableByteChannel) {
        this.channel = Preconditions.checkNotNull(writableByteChannel, "output channel is null");
    }

    public WritableByteChannel reset(WritableByteChannel writableByteChannel) throws IOException {
        WritableByteChannel writableByteChannel2 = this.channel;
        this.channel = writableByteChannel;
        return writableByteChannel2;
    }

    @Override
    public MessageBuffer next(int n) throws IOException {
        if (this.buffer == null || this.buffer.size() != n) {
            this.buffer = MessageBuffer.newBuffer(n);
        }
        return this.buffer;
    }

    @Override
    public void flush(MessageBuffer messageBuffer) throws IOException {
        ByteBuffer byteBuffer = messageBuffer.toByteBuffer();
        this.channel.write(byteBuffer);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

