/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.htrace.core.Span;
import org.apache.htrace.impl.BufferManager;
import org.apache.htrace.impl.Conf;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;
import org.apache.htrace.shaded.jetty.client.HttpClient;
import org.apache.htrace.shaded.jetty.client.api.ContentProvider;
import org.apache.htrace.shaded.jetty.client.api.ContentResponse;
import org.apache.htrace.shaded.jetty.client.api.Request;
import org.apache.htrace.shaded.jetty.http.HttpField;
import org.apache.htrace.shaded.jetty.http.HttpHeader;
import org.apache.htrace.shaded.jetty.http.HttpMethod;

class RestBufferManager
implements BufferManager {
    private static final Log LOG = LogFactory.getLog(RestBufferManager.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final int MAX_PREQUEL_LENGTH = 512;
    private final Conf conf;
    private final HttpClient httpClient;
    private final String urlString;
    private final ByteBuffer prequel;
    private final ByteBuffer spans;
    private int numSpans;

    static HttpClient createHttpClient(long connTimeout, long idleTimeout) {
        HttpClient httpClient = new HttpClient();
        httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, "HTracedSpanReceiver"));
        httpClient.setConnectTimeout(connTimeout);
        httpClient.setIdleTimeout(idleTimeout);
        return httpClient;
    }

    RestBufferManager(Conf conf) throws Exception {
        this.conf = conf;
        this.httpClient = RestBufferManager.createHttpClient(conf.connectTimeoutMs, conf.idleTimeoutMs);
        this.urlString = new URL("http", conf.endpoint.getHostName(), conf.endpoint.getPort(), "/writeSpans").toString();
        this.prequel = ByteBuffer.allocate(512);
        this.spans = ByteBuffer.allocate(conf.bufferSize);
        this.clear();
        this.httpClient.start();
    }

    @Override
    public void writeSpan(Span span) throws IOException {
        byte[] spanJsonBytes = span.toString().getBytes(UTF8);
        if (this.spans.capacity() - this.spans.position() < spanJsonBytes.length) {
            throw new IOException("Not enough space remaining in span buffer.");
        }
        this.spans.put(spanJsonBytes);
        ++this.numSpans;
    }

    @Override
    public int contentLength() {
        return Math.max(this.spans.position() - 1, 0);
    }

    @Override
    public int getNumberOfSpans() {
        return this.numSpans;
    }

    @Override
    public void prepare() throws IOException {
        StringBuilder bld = new StringBuilder();
        bld.append("{\"NumSpans\":").append(this.numSpans).append("}");
        String prequelString = bld.toString();
        this.prequel.put(prequelString.getBytes(UTF8));
        this.prequel.flip();
        this.spans.flip();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Preparing to send " + this.contentLength() + " bytes of span " + "data to " + this.conf.endpointStr + ", containing " + this.numSpans + " spans.");
        }
    }

    @Override
    public void flush() throws IOException {
        this.prequel.position(0);
        this.spans.position(0);
        RestBufferManagerContentProvider contentProvider = new RestBufferManagerContentProvider(new ByteBuffer[]{this.prequel, this.spans});
        long rpcLength = contentProvider.getLength();
        try {
            Request request = this.httpClient.newRequest(this.urlString).method(HttpMethod.POST);
            request.header(HttpHeader.CONTENT_TYPE, "application/json");
            request.content(contentProvider);
            ContentResponse response = request.send();
            if (response.getStatus() != 200) {
                throw new IOException("Got back error response " + response.getStatus() + " from " + this.conf.endpointStr + "; " + response.getContentAsString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sent WriteSpansReq of length " + rpcLength + " to " + this.conf.endpointStr);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while sending spans via REST", e);
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out sending spans via REST", e);
        }
        catch (ExecutionException e) {
            throw new IOException("Execution exception sending spans via REST", e);
        }
    }

    @Override
    public void clear() {
        this.prequel.clear();
        this.spans.clear();
        this.numSpans = 0;
    }

    @Override
    public void close() {
        try {
            this.httpClient.stop();
        }
        catch (Exception e) {
            LOG.error("Error stopping HTracedReceiver httpClient", e);
        }
    }

    private static class RestBufferManagerContentProvider
    implements ContentProvider {
        private final ByteBuffer[] bufs;

        RestBufferManagerContentProvider(ByteBuffer[] bufs) {
            this.bufs = bufs;
        }

        @Override
        public long getLength() {
            long total = 0L;
            for (int i = 0; i < this.bufs.length; ++i) {
                total += (long)this.bufs[i].remaining();
            }
            return total;
        }

        @Override
        public Iterator<ByteBuffer> iterator() {
            return new ByteBufferIterator();
        }

        private class ByteBufferIterator
        implements Iterator<ByteBuffer> {
            private int bufIdx = -1;

            private ByteBufferIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.bufIdx + 1 < RestBufferManagerContentProvider.this.bufs.length;
            }

            @Override
            public ByteBuffer next() {
                if (this.bufIdx + 1 >= RestBufferManagerContentProvider.this.bufs.length) {
                    throw new NoSuchElementException();
                }
                ++this.bufIdx;
                return RestBufferManagerContentProvider.this.bufs[this.bufIdx];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

