/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.util.concurrent.TimeUnit;
import org.apache.htrace.shaded.commons.logging.Log;

class RateLimitedLogger {
    private final Log log;
    private final long timeoutMs;
    private long lastLogTimeMs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLimitedLogger(Log log, long timeoutMs) {
        this.log = log;
        this.timeoutMs = timeoutMs;
        RateLimitedLogger rateLimitedLogger = this;
        synchronized (rateLimitedLogger) {
            this.lastLogTimeMs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String what) {
        long now = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        RateLimitedLogger rateLimitedLogger = this;
        synchronized (rateLimitedLogger) {
            if (now >= this.lastLogTimeMs + this.timeoutMs) {
                this.log.warn(what);
                this.lastLogTimeMs = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String what) {
        long now = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        RateLimitedLogger rateLimitedLogger = this;
        synchronized (rateLimitedLogger) {
            if (now >= this.lastLogTimeMs + this.timeoutMs) {
                this.log.error(what);
                this.lastLogTimeMs = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String what, Throwable e) {
        long now = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        RateLimitedLogger rateLimitedLogger = this;
        synchronized (rateLimitedLogger) {
            if (now >= this.lastLogTimeMs + this.timeoutMs) {
                this.log.error(what, e);
                this.lastLogTimeMs = now;
            }
        }
    }
}

