/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.jetty.client;

import java.net.URI;
import org.apache.htrace.jetty.client.AuthenticationProtocolHandler;
import org.apache.htrace.jetty.client.HttpClient;
import org.apache.htrace.jetty.client.HttpDestination;
import org.apache.htrace.jetty.client.ProxyConfiguration;
import org.apache.htrace.jetty.client.api.Request;
import org.apache.htrace.jetty.client.api.Response;
import org.apache.htrace.jetty.http.HttpHeader;

public class ProxyAuthenticationProtocolHandler
extends AuthenticationProtocolHandler {
    public ProxyAuthenticationProtocolHandler(HttpClient client) {
        this(client, 4096);
    }

    public ProxyAuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        super(client, maxContentLength);
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.getStatus() == 407;
    }

    @Override
    protected HttpHeader getAuthenticateHeader() {
        return HttpHeader.PROXY_AUTHENTICATE;
    }

    @Override
    protected HttpHeader getAuthorizationHeader() {
        return HttpHeader.PROXY_AUTHORIZATION;
    }

    @Override
    protected URI getAuthenticationURI(Request request) {
        HttpDestination destination = this.getHttpClient().destinationFor(request.getScheme(), request.getHost(), request.getPort());
        ProxyConfiguration.Proxy proxy = destination.getProxy();
        return proxy != null ? proxy.getURI() : request.getURI();
    }
}

