/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.org.eclipse.jetty.util;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.htrace.shaded.org.eclipse.jetty.util.MemoryUtils;

public class ConcurrentArrayQueue<T>
extends AbstractQueue<T> {
    public static final int DEFAULT_BLOCK_SIZE = 512;
    public static final Object REMOVED_ELEMENT = new Object(){

        public String toString() {
            return "X";
        }
    };
    private static final int HEAD_OFFSET = MemoryUtils.getIntegersPerCacheLine() - 1;
    private static final int TAIL_OFFSET = MemoryUtils.getIntegersPerCacheLine() * 2 - 1;
    private final AtomicReferenceArray<Block<T>> _blocks = new AtomicReferenceArray(TAIL_OFFSET + 1);
    private final int _blockSize;

    public ConcurrentArrayQueue() {
        this(512);
    }

    public ConcurrentArrayQueue(int blockSize) {
        this._blockSize = blockSize;
        Block<T> block = this.newBlock();
        this._blocks.set(HEAD_OFFSET, block);
        this._blocks.set(TAIL_OFFSET, block);
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    protected Block<T> getHeadBlock() {
        return this._blocks.get(HEAD_OFFSET);
    }

    protected Block<T> getTailBlock() {
        return this._blocks.get(TAIL_OFFSET);
    }

    @Override
    public boolean offer(T item) {
        Block<T> initialTailBlock;
        item = Objects.requireNonNull(item);
        Block<T> currentTailBlock = initialTailBlock = this.getTailBlock();
        int tail = currentTailBlock.tail();
        while (true) {
            if (tail == this.getBlockSize()) {
                Block<T> nextTailBlock = currentTailBlock.next();
                currentTailBlock = nextTailBlock == null ? (currentTailBlock.link(nextTailBlock = this.newBlock()) ? nextTailBlock : currentTailBlock.next()) : nextTailBlock;
                tail = currentTailBlock.tail();
                continue;
            }
            if (currentTailBlock.peek(tail) == null) {
                if (currentTailBlock.store(tail, item)) break;
                ++tail;
                continue;
            }
            ++tail;
        }
        this.updateTailBlock(initialTailBlock, currentTailBlock);
        return true;
    }

    private void updateTailBlock(Block<T> oldTailBlock, Block<T> newTailBlock) {
        if (oldTailBlock != newTailBlock) {
            this.casTailBlock(oldTailBlock, newTailBlock);
        }
    }

    protected boolean casTailBlock(Block<T> current, Block<T> update) {
        return this._blocks.compareAndSet(TAIL_OFFSET, current, update);
    }

    @Override
    public T poll() {
        Block<T> initialHeadBlock;
        Block<T> currentHeadBlock = initialHeadBlock = this.getHeadBlock();
        int head = currentHeadBlock.head();
        T result = null;
        while (true) {
            if (head == this.getBlockSize()) {
                Block<T> nextHeadBlock = currentHeadBlock.next();
                if (nextHeadBlock == null) break;
                currentHeadBlock = nextHeadBlock;
                head = currentHeadBlock.head();
                continue;
            }
            T element = currentHeadBlock.peek(head);
            if (element == REMOVED_ELEMENT) {
                ++head;
                continue;
            }
            result = element;
            if (result == null || currentHeadBlock.remove(head, result, true)) break;
            ++head;
        }
        this.updateHeadBlock(initialHeadBlock, currentHeadBlock);
        return result;
    }

    private void updateHeadBlock(Block<T> oldHeadBlock, Block<T> newHeadBlock) {
        if (oldHeadBlock != newHeadBlock) {
            this.casHeadBlock(oldHeadBlock, newHeadBlock);
        }
    }

    protected boolean casHeadBlock(Block<T> current, Block<T> update) {
        return this._blocks.compareAndSet(HEAD_OFFSET, current, update);
    }

    @Override
    public T peek() {
        T element;
        Block<T> currentHeadBlock = this.getHeadBlock();
        int head = currentHeadBlock.head();
        while (true) {
            if (head == this.getBlockSize()) {
                Block<T> nextHeadBlock = currentHeadBlock.next();
                if (nextHeadBlock == null) {
                    return null;
                }
                currentHeadBlock = nextHeadBlock;
                head = currentHeadBlock.head();
                continue;
            }
            element = currentHeadBlock.peek(head);
            if (element != REMOVED_ELEMENT) break;
            ++head;
        }
        return element;
    }

    @Override
    public boolean remove(Object o) {
        Block<T> currentHeadBlock = this.getHeadBlock();
        int head = currentHeadBlock.head();
        boolean result = false;
        while (true) {
            if (head == this.getBlockSize()) {
                Block<T> nextHeadBlock = currentHeadBlock.next();
                if (nextHeadBlock == null) break;
                currentHeadBlock = nextHeadBlock;
                head = currentHeadBlock.head();
                continue;
            }
            T element = currentHeadBlock.peek(head);
            if (element == REMOVED_ELEMENT) {
                ++head;
                continue;
            }
            if (element == null) break;
            if (element.equals(o)) {
                if (currentHeadBlock.remove(head, o, false)) {
                    result = true;
                    break;
                }
                ++head;
                continue;
            }
            ++head;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public Iterator<T> iterator() {
        final ArrayList<Object[]> blocks = new ArrayList<Object[]>();
        for (Block<T> currentHeadBlock = this.getHeadBlock(); currentHeadBlock != null; currentHeadBlock = currentHeadBlock.next()) {
            Object[] elements = currentHeadBlock.arrayCopy();
            blocks.add(elements);
        }
        return new Iterator<T>(){
            private int blockIndex;
            private int index;

            @Override
            public boolean hasNext() {
                while (this.blockIndex != blocks.size()) {
                    Object element = ((Object[])blocks.get(this.blockIndex))[this.index];
                    if (element == null) {
                        return false;
                    }
                    if (element != REMOVED_ELEMENT) {
                        return true;
                    }
                    this.advance();
                }
                return false;
            }

            @Override
            public T next() {
                Object element;
                do {
                    if (this.blockIndex == blocks.size()) {
                        throw new NoSuchElementException();
                    }
                    element = ((Object[])blocks.get(this.blockIndex))[this.index];
                    if (element == null) {
                        throw new NoSuchElementException();
                    }
                    this.advance();
                } while (element == REMOVED_ELEMENT);
                Object e = element;
                return e;
            }

            private void advance() {
                if (++this.index == ConcurrentArrayQueue.this.getBlockSize()) {
                    this.index = 0;
                    ++this.blockIndex;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        Block<T> currentHeadBlock = this.getHeadBlock();
        int head = currentHeadBlock.head();
        int size = 0;
        while (true) {
            if (head == this.getBlockSize()) {
                Block<T> nextHeadBlock = currentHeadBlock.next();
                if (nextHeadBlock == null) break;
                currentHeadBlock = nextHeadBlock;
                head = currentHeadBlock.head();
                continue;
            }
            T element = currentHeadBlock.peek(head);
            if (element == REMOVED_ELEMENT) {
                ++head;
                continue;
            }
            if (element == null) break;
            ++size;
            ++head;
        }
        return size;
    }

    protected Block<T> newBlock() {
        return new Block(this.getBlockSize());
    }

    protected int getBlockCount() {
        int result = 0;
        for (Block<T> headBlock = this.getHeadBlock(); headBlock != null; headBlock = headBlock.next()) {
            ++result;
        }
        return result;
    }

    static /* synthetic */ int access$000() {
        return TAIL_OFFSET;
    }

    protected static final class Block<E> {
        private static final int headOffset = MemoryUtils.getIntegersPerCacheLine() - 1;
        private static final int tailOffset = MemoryUtils.getIntegersPerCacheLine() * 2 - 1;
        private final AtomicReferenceArray<Object> elements;
        private final AtomicReference<Block<E>> next = new AtomicReference();
        private final AtomicIntegerArray indexes = new AtomicIntegerArray(ConcurrentArrayQueue.access$000() + 1);

        protected Block(int blockSize) {
            this.elements = new AtomicReferenceArray(blockSize);
        }

        public E peek(int index) {
            return (E)this.elements.get(index);
        }

        public boolean store(int index, E item) {
            boolean result = this.elements.compareAndSet(index, null, item);
            if (result) {
                this.indexes.incrementAndGet(tailOffset);
            }
            return result;
        }

        public boolean remove(int index, Object item, boolean updateHead) {
            boolean result = this.elements.compareAndSet(index, item, REMOVED_ELEMENT);
            if (result && updateHead) {
                this.indexes.incrementAndGet(headOffset);
            }
            return result;
        }

        public Block<E> next() {
            return this.next.get();
        }

        public boolean link(Block<E> nextBlock) {
            return this.next.compareAndSet(null, nextBlock);
        }

        public int head() {
            return this.indexes.get(headOffset);
        }

        public int tail() {
            return this.indexes.get(tailOffset);
        }

        public Object[] arrayCopy() {
            Object[] result = new Object[this.elements.length()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.elements.get(i);
            }
            return result;
        }
    }
}

