/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.viewer;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.htrace.protobuf.generated.SpanProtos;
import org.apache.htrace.shaded.commons.logging.Log;
import org.apache.htrace.shaded.commons.logging.LogFactory;
import org.apache.htrace.shaded.javax.servlet.ServletException;
import org.apache.htrace.shaded.javax.servlet.http.HttpServlet;
import org.apache.htrace.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.htrace.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.htrace.viewer.HBaseSpanViewer;

public class HBaseSpanViewerTracesServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(HBaseSpanViewerTracesServlet.class);
    public static final String PREFIX = "/gettraces";
    private static final ThreadLocal<HBaseSpanViewer> tlviewer = new ThreadLocal<HBaseSpanViewer>(){

        @Override
        protected HBaseSpanViewer initialValue() {
            return null;
        }
    };
    private Configuration conf;

    public HBaseSpanViewerTracesServlet(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HBaseSpanViewer viewer = tlviewer.get();
        if (viewer == null) {
            viewer = new HBaseSpanViewer(this.conf);
            tlviewer.set(viewer);
        }
        response.setContentType("application/javascript");
        PrintWriter out = response.getWriter();
        out.print("[");
        boolean first = true;
        for (SpanProtos.Span span : viewer.getRootSpans()) {
            if (first) {
                first = false;
            } else {
                out.print(",");
            }
            out.print(HBaseSpanViewer.toJsonString(span));
        }
        out.print("]");
    }

    @Override
    public void init() throws ServletException {
    }

    @Override
    public void destroy() {
        HBaseSpanViewer viewer = tlviewer.get();
        if (viewer != null) {
            viewer.close();
        }
    }
}

