/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.List;
import org.apache.htrace.shaded.javax.servlet.ServletException;
import org.apache.htrace.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.htrace.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.htrace.shaded.org.eclipse.jetty.server.Handler;
import org.apache.htrace.shaded.org.eclipse.jetty.server.Request;
import org.apache.htrace.shaded.org.eclipse.jetty.server.Server;
import org.apache.htrace.shaded.org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.apache.htrace.shaded.org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.apache.htrace.shaded.org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Handler wrapping another Handler")
public class HandlerWrapper
extends AbstractHandlerContainer {
    protected Handler _handler;

    @ManagedAttribute(value="Wrapped Handler", readonly=true)
    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        if (this._handler == null) {
            return new Handler[0];
        }
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        if (handler != null) {
            handler.setServer(this.getServer());
        }
        Handler old = this._handler;
        this._handler = handler;
        this.updateBean(old, this._handler);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    public void setServer(Server server) {
        if (server == this.getServer()) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        this.expandHandler(this._handler, list, byClass);
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler(null);
            child.destroy();
        }
        super.destroy();
    }
}

