/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.viewer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.htrace.com.google.protobuf.Descriptors;
import org.apache.htrace.com.google.protobuf.Message;
import org.apache.htrace.commons.logging.Log;
import org.apache.htrace.commons.logging.LogFactory;
import org.apache.htrace.impl.HBaseSpanReceiver;
import org.apache.htrace.protobuf.generated.SpanProtos;

public class HBaseSpanViewer {
    private static final Log LOG = LogFactory.getLog(HBaseSpanViewer.class);
    private Configuration conf;
    private HConnection hconnection;
    private HTableInterface htable;
    private byte[] table;
    private byte[] cf;
    private byte[] icf;

    public HBaseSpanViewer(Configuration conf) {
        this.conf = conf;
        this.table = Bytes.toBytes((String)conf.get("htrace.hbase.table", "htrace"));
        this.cf = Bytes.toBytes((String)conf.get("htrace.hbase.columnfamily", "s"));
        this.icf = Bytes.toBytes((String)conf.get("htrace.hbase.indexfamily", "i"));
    }

    public void close() {
        this.stopClient();
    }

    public void startClient() {
        if (this.htable == null) {
            try {
                this.hconnection = HConnectionManager.createConnection((Configuration)this.conf);
                this.htable = this.hconnection.getTable(this.table);
            }
            catch (IOException e) {
                LOG.warn("Failed to create HBase connection. " + e.getMessage());
            }
        }
    }

    public void stopClient() {
        try {
            if (this.htable != null) {
                this.htable.close();
                this.htable = null;
            }
            if (this.hconnection != null) {
                this.hconnection.close();
                this.hconnection = null;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to close HBase connection. " + e.getMessage());
        }
    }

    public List<SpanProtos.Span> getSpans(long traceid) throws IOException {
        this.startClient();
        ArrayList<SpanProtos.Span> spans = new ArrayList<SpanProtos.Span>();
        Get get = new Get(Bytes.toBytes((long)traceid));
        get.addFamily(this.cf);
        try {
            for (Cell cell : this.htable.get(get).listCells()) {
                ByteArrayInputStream in = new ByteArrayInputStream(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
                spans.add(SpanProtos.Span.parseFrom(in));
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to get spans from HBase. " + e.getMessage());
            this.stopClient();
        }
        return spans;
    }

    public List<SpanProtos.Span> getRootSpans() throws IOException {
        this.startClient();
        Scan scan = new Scan();
        scan.addColumn(this.icf, HBaseSpanReceiver.INDEX_SPAN_QUAL);
        ArrayList<SpanProtos.Span> spans = new ArrayList<SpanProtos.Span>();
        try {
            ResultScanner scanner = this.htable.getScanner(scan);
            Result result = null;
            while ((result = scanner.next()) != null) {
                for (Cell cell : result.listCells()) {
                    ByteArrayInputStream in = new ByteArrayInputStream(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
                    spans.add(SpanProtos.Span.parseFrom(in));
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to get root spans from HBase. " + e.getMessage());
            this.stopClient();
        }
        return spans;
    }

    public static String toJsonString(Message message) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, Charset.defaultCharset());
        HBaseSpanViewer.appendJsonString(message, writer);
        writer.flush();
        out.flush();
        return out.toString();
    }

    public static void appendJsonString(Message message, OutputStreamWriter writer) throws IOException {
        writer.append("{");
        Iterator<Map.Entry<Descriptors.FieldDescriptor, Object>> iter = message.getAllFields().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Descriptors.FieldDescriptor, Object> field = iter.next();
            HBaseSpanViewer.appendFields(field.getKey(), field.getValue(), writer);
            if (!iter.hasNext()) continue;
            writer.append(",");
        }
        writer.append("}");
    }

    private static void appendFields(Descriptors.FieldDescriptor fd, Object value, OutputStreamWriter writer) throws IOException {
        writer.append("\"");
        writer.append(fd.getName());
        writer.append("\"");
        writer.append(":");
        if (fd.isRepeated()) {
            writer.append("[");
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                HBaseSpanViewer.appendValue(fd, it.next(), writer);
                if (!it.hasNext()) continue;
                writer.append(",");
            }
            writer.append("]");
        } else {
            HBaseSpanViewer.appendValue(fd, value, writer);
        }
    }

    private static void appendValue(Descriptors.FieldDescriptor fd, Object value, OutputStreamWriter writer) throws IOException {
        switch (fd.getType()) {
            case INT64: 
            case STRING: {
                writer.append("\"");
                writer.append(value.toString());
                writer.append("\"");
                break;
            }
            case MESSAGE: {
                HBaseSpanViewer.appendJsonString((Message)value, writer);
                break;
            }
            default: {
                throw new IOException("unexpected field type.");
            }
        }
    }

    public static void main(String[] args) throws IOException {
        HBaseSpanViewer viewer = new HBaseSpanViewer(HBaseConfiguration.create());
        if (args.length == 0) {
            List<SpanProtos.Span> spans = viewer.getRootSpans();
            for (SpanProtos.Span span : spans) {
                System.out.println(HBaseSpanViewer.toJsonString(span));
            }
        } else {
            List<SpanProtos.Span> spans = viewer.getSpans(Long.parseLong(args[0]));
            for (SpanProtos.Span span : spans) {
                System.out.println(HBaseSpanViewer.toJsonString(span));
            }
        }
        viewer.close();
    }
}

