/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.htrace.HBaseHTraceConfiguration;
import org.apache.htrace.commons.logging.Log;
import org.apache.htrace.commons.logging.LogFactory;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.TimelineAnnotation;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;
import org.apache.htrace.protobuf.generated.SpanProtos;

public class HBaseSpanReceiver
extends SpanReceiver {
    private static final Log LOG = LogFactory.getLog(HBaseSpanReceiver.class);
    public static final String COLLECTOR_QUORUM_KEY = "htrace.hbase.collector-quorum";
    public static final String DEFAULT_COLLECTOR_QUORUM = "127.0.0.1";
    public static final String ZOOKEEPER_CLIENT_PORT_KEY = "htrace.hbase.zookeeper.property.clientPort";
    public static final int DEFAULT_ZOOKEEPER_CLIENT_PORT = 2181;
    public static final String ZOOKEEPER_ZNODE_PARENT_KEY = "htrace.hbase.zookeeper.znode.parent";
    public static final String DEFAULT_ZOOKEEPER_ZNODE_PARENT = "/hbase";
    public static final String NUM_THREADS_KEY = "htrace.hbase.num-threads";
    public static final int DEFAULT_NUM_THREADS = 1;
    public static final String MAX_SPAN_BATCH_SIZE_KEY = "htrace.hbase.batch.size";
    public static final int DEFAULT_MAX_SPAN_BATCH_SIZE = 100;
    public static final String TABLE_KEY = "htrace.hbase.table";
    public static final String DEFAULT_TABLE = "htrace";
    public static final String COLUMNFAMILY_KEY = "htrace.hbase.columnfamily";
    public static final String DEFAULT_COLUMNFAMILY = "s";
    public static final String INDEXFAMILY_KEY = "htrace.hbase.indexfamily";
    public static final String DEFAULT_INDEXFAMILY = "i";
    public static final byte[] INDEX_SPAN_QUAL = Bytes.toBytes((String)"s");
    public static final byte[] INDEX_TIME_QUAL = Bytes.toBytes((String)"t");
    private static final int SHUTDOWN_TIMEOUT = 30;
    private static final int MAX_ERRORS = 10;
    private final BlockingQueue<Span> queue;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final ThreadFactory tf = new ThreadFactory(){
        private final AtomicLong receiverIdx = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(String.format("hbaseSpanReceiver-%d", this.receiverIdx.getAndIncrement()));
            return t;
        }
    };
    private ExecutorService service;
    private final HTraceConfiguration conf;
    private final Configuration hconf;
    private final byte[] table;
    private final byte[] cf;
    private final byte[] icf;
    private final int maxSpanBatchSize;

    public HBaseSpanReceiver(HTraceConfiguration conf) {
        this.queue = new ArrayBlockingQueue<Span>(1000);
        this.conf = conf;
        this.hconf = HBaseConfiguration.create();
        this.table = Bytes.toBytes((String)conf.get(TABLE_KEY, DEFAULT_TABLE));
        this.cf = Bytes.toBytes((String)conf.get(COLUMNFAMILY_KEY, DEFAULT_COLUMNFAMILY));
        this.icf = Bytes.toBytes((String)conf.get(INDEXFAMILY_KEY, DEFAULT_INDEXFAMILY));
        this.maxSpanBatchSize = conf.getInt(MAX_SPAN_BATCH_SIZE_KEY, 100);
        String quorum = conf.get(COLLECTOR_QUORUM_KEY, DEFAULT_COLLECTOR_QUORUM);
        this.hconf.set("hbase.zookeeper.quorum", quorum);
        String znodeParent = conf.get(ZOOKEEPER_ZNODE_PARENT_KEY, DEFAULT_ZOOKEEPER_ZNODE_PARENT);
        this.hconf.set("zookeeper.znode.parent", znodeParent);
        int clientPort = conf.getInt(ZOOKEEPER_CLIENT_PORT_KEY, 2181);
        this.hconf.setInt("hbase.zookeeper.property.clientPort", clientPort);
        if (this.service != null) {
            this.service.shutdownNow();
            this.service = null;
        }
        int numThreads = conf.getInt(NUM_THREADS_KEY, 1);
        this.service = Executors.newFixedThreadPool(numThreads, this.tf);
        for (int i = 0; i < numThreads; ++i) {
            this.service.submit(new WriteSpanRunnable());
        }
    }

    public void close() throws IOException {
        this.running.set(false);
        this.service.shutdown();
        try {
            if (!this.service.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOG.error("Was not able to process all remaining spans upon closing in: 30 " + (Object)((Object)TimeUnit.SECONDS) + ". Left Spans could be dropped.");
            }
        }
        catch (InterruptedException e1) {
            LOG.warn("Thread interrupted when terminating executor.", e1);
        }
    }

    public void receiveSpan(Span span) {
        if (this.running.get()) {
            try {
                this.queue.add(span);
            }
            catch (IllegalStateException e) {
                LOG.error("Error trying to append span (" + span.getDescription() + ") to the queue. Blocking Queue was full.");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Tracer tracer = new Tracer.Builder().conf((HTraceConfiguration)new HBaseHTraceConfiguration(HBaseConfiguration.create())).build();
        tracer.addSampler(Sampler.ALWAYS);
        TraceScope parent = tracer.newScope("HBaseSpanReceiver.main.parent");
        Thread.sleep(10L);
        long traceid = parent.getSpan().getSpanId().getHigh();
        TraceScope child1 = tracer.newScope("HBaseSpanReceiver.main.child.1");
        Thread.sleep(10L);
        child1.close();
        TraceScope child2 = tracer.newScope("HBaseSpanReceiver.main.child.2");
        Thread.sleep(10L);
        TraceScope gchild = tracer.newScope("HBaseSpanReceiver.main.grandchild");
        gchild.addTimelineAnnotation("annotation 1.");
        Thread.sleep(10L);
        gchild.addTimelineAnnotation("annotation 2.");
        gchild.close();
        Thread.sleep(10L);
        child2.close();
        Thread.sleep(10L);
        parent.close();
        tracer.close();
        System.out.println("trace id: " + traceid);
    }

    private class WriteSpanRunnable
    implements Runnable {
        private Connection hconnection;
        private Table htable;

        @Override
        public void run() {
            SpanProtos.Span.Builder sbuilder = SpanProtos.Span.newBuilder();
            SpanProtos.TimelineAnnotation.Builder tlbuilder = SpanProtos.TimelineAnnotation.newBuilder();
            ArrayList<Span> dequeuedSpans = new ArrayList<Span>(HBaseSpanReceiver.this.maxSpanBatchSize);
            long errorCount = 0L;
            while (HBaseSpanReceiver.this.running.get() || HBaseSpanReceiver.this.queue.size() > 0) {
                Span firstSpan = null;
                try {
                    firstSpan = (Span)HBaseSpanReceiver.this.queue.poll(1L, TimeUnit.SECONDS);
                    if (firstSpan != null) {
                        dequeuedSpans.add(firstSpan);
                        HBaseSpanReceiver.this.queue.drainTo(dequeuedSpans, HBaseSpanReceiver.this.maxSpanBatchSize - 1);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.startClient();
                if (dequeuedSpans.isEmpty()) {
                    try {
                        this.htable.flushCommits();
                    }
                    catch (IOException e) {
                        LOG.error("failed to flush writes to HBase.");
                        this.closeClient();
                    }
                    continue;
                }
                try {
                    for (Span span : dequeuedSpans) {
                        sbuilder.clear().setTraceId(span.getSpanId().getHigh()).setStart(span.getStartTimeMillis()).setStop(span.getStopTimeMillis()).setSpanId(span.getSpanId().getLow()).setProcessId(span.getTracerId()).setDescription(span.getDescription());
                        if (span.getParents().length == 0) {
                            sbuilder.setParentId(0L);
                        } else if (span.getParents().length > 0) {
                            sbuilder.setParentId(span.getParents()[0].getLow());
                            if (span.getParents().length > 1) {
                                LOG.error("error: HBaseSpanReceiver does not support spans with multiple parents.  Ignoring multiple parents for " + span);
                            }
                        }
                        for (TimelineAnnotation ta : span.getTimelineAnnotations()) {
                            sbuilder.addTimeline(tlbuilder.clear().setTime(ta.getTime()).setMessage(ta.getMessage()).build());
                        }
                        Put put = new Put(Bytes.toBytes((long)span.getSpanId().getHigh()));
                        put.add(HBaseSpanReceiver.this.cf, sbuilder.build().toByteArray(), null);
                        if (span.getParents().length == 0) {
                            put.add(HBaseSpanReceiver.this.icf, INDEX_TIME_QUAL, Bytes.toBytes((long)span.getStartTimeMillis()));
                            put.add(HBaseSpanReceiver.this.icf, INDEX_SPAN_QUAL, sbuilder.build().toByteArray());
                        }
                        this.htable.put(put);
                    }
                    dequeuedSpans.clear();
                    errorCount = 0L;
                }
                catch (Exception e) {
                    if (++errorCount < 10L) {
                        try {
                            HBaseSpanReceiver.this.queue.addAll(dequeuedSpans);
                        }
                        catch (IllegalStateException ex) {
                            LOG.error("Drop " + dequeuedSpans.size() + " span(s) because writing to HBase failed.");
                        }
                    }
                    this.closeClient();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {}
                }
            }
            this.closeClient();
        }

        private void closeClient() {
            try {
                if (this.htable != null) {
                    this.htable.close();
                    this.htable = null;
                }
                if (this.hconnection != null) {
                    this.hconnection.close();
                    this.hconnection = null;
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to close HBase connection. " + e.getMessage());
            }
        }

        private void startClient() {
            if (this.htable == null) {
                try {
                    this.hconnection = ConnectionFactory.createConnection((Configuration)HBaseSpanReceiver.this.hconf);
                    this.htable = this.hconnection.getTable(TableName.valueOf((byte[])HBaseSpanReceiver.this.table));
                }
                catch (IOException e) {
                    LOG.warn("Failed to create HBase connection. " + e.getMessage());
                }
            }
        }
    }
}

