/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MicroBenchmark {
    private static final int WARMUP_DEFAULT = 15;
    private static final int ITERATIONS_DEFAULT = 100;
    private static final int SCALE_DEFAULT = 1;
    private final int warmup;
    private final int iterations;
    private final int scaleFactor;

    public MicroBenchmark() {
        this(15, 100, 1);
    }

    MicroBenchmark(int warmup, int iterations) {
        this(warmup, iterations, 1);
    }

    private MicroBenchmark(int warmup, int iterations, int scaleFactor) {
        this.warmup = warmup;
        this.iterations = iterations;
        this.scaleFactor = scaleFactor;
    }

    public DescriptiveStatistics measure(@Nullable Runnable pre, @NotNull Runnable test, @Nullable Runnable post) {
        for (int i = 0; i < this.warmup; ++i) {
            if (pre != null) {
                pre.run();
            }
            test.run();
            if (post == null) continue;
            post.run();
        }
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < this.iterations; ++i) {
            if (pre != null) {
                pre.run();
            }
            long start = System.nanoTime();
            test.run();
            long end = System.nanoTime();
            stats.addValue((double)(end - start) / (double)this.scaleFactor);
            if (post == null) continue;
            post.run();
        }
        return stats;
    }

    public DescriptiveStatistics measure(@NotNull Runnable test) {
        return this.measure(null, test, null);
    }
}

