/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafkaesqueesque.common.TopicPartition;
import org.apache.kafkaesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesque.common.message.OffsetCommitRequestData;
import org.apache.kafkaesqueesque.common.message.OffsetCommitResponseData;
import org.apache.kafkaesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesque.common.protocol.Errors;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.requests.AbstractRequest;
import org.apache.kafkaesqueesque.common.requests.OffsetCommitResponse;

public class OffsetCommitRequest
extends AbstractRequest {
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_MEMBER_ID = "";
    public static final long DEFAULT_RETENTION_TIME = -1L;
    @Deprecated
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final OffsetCommitRequestData data;
    private final short version;

    public OffsetCommitRequest(OffsetCommitRequestData data, short version) {
        super(ApiKeys.OFFSET_COMMIT, version);
        this.data = data;
        this.version = version;
    }

    public OffsetCommitRequest(Struct struct, short version) {
        super(ApiKeys.OFFSET_COMMIT, version);
        this.data = new OffsetCommitRequestData(struct, version);
        this.version = version;
    }

    public OffsetCommitRequestData data() {
        return this.data;
    }

    public Map<TopicPartition, Long> offsets() {
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        for (OffsetCommitRequestData.OffsetCommitRequestTopic topic : this.data.topics()) {
            for (OffsetCommitRequestData.OffsetCommitRequestPartition partition : topic.partitions()) {
                offsets.put(new TopicPartition(topic.name(), partition.partitionIndex()), partition.committedOffset());
            }
        }
        return offsets;
    }

    public static List<OffsetCommitResponseData.OffsetCommitResponseTopic> getErrorResponseTopics(List<OffsetCommitRequestData.OffsetCommitRequestTopic> requestTopics, Errors e) {
        ArrayList<OffsetCommitResponseData.OffsetCommitResponseTopic> responseTopicData = new ArrayList<OffsetCommitResponseData.OffsetCommitResponseTopic>();
        for (OffsetCommitRequestData.OffsetCommitRequestTopic entry : requestTopics) {
            ArrayList<OffsetCommitResponseData.OffsetCommitResponsePartition> responsePartitions = new ArrayList<OffsetCommitResponseData.OffsetCommitResponsePartition>();
            for (OffsetCommitRequestData.OffsetCommitRequestPartition requestPartition : entry.partitions()) {
                responsePartitions.add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(requestPartition.partitionIndex()).setErrorCode(e.code()));
            }
            responseTopicData.add(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(entry.name()).setPartitions(responsePartitions));
        }
        return responseTopicData;
    }

    @Override
    public OffsetCommitResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        List<OffsetCommitResponseData.OffsetCommitResponseTopic> responseTopicData = OffsetCommitRequest.getErrorResponseTopics(this.data.topics(), Errors.forException(e));
        return new OffsetCommitResponse(new OffsetCommitResponseData().setTopics(responseTopicData).setThrottleTimeMs(throttleTimeMs));
    }

    public static OffsetCommitRequest parse(ByteBuffer buffer, short version) {
        return new OffsetCommitRequest(ApiKeys.OFFSET_COMMIT.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetCommitRequest> {
        private final OffsetCommitRequestData data;

        public Builder(OffsetCommitRequestData data) {
            super(ApiKeys.OFFSET_COMMIT);
            this.data = data;
        }

        @Override
        public OffsetCommitRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 7) {
                throw new UnsupportedVersionException("The broker offset commit protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new OffsetCommitRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

