/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.security.oauthbearer.internals;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.kafkaesque.common.errors.SaslAuthenticationException;
import org.apache.kafkaesque.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafkaesque.common.security.auth.SaslExtensions;
import org.apache.kafkaesque.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafkaesque.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafkaesque.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafkaesque.common.security.oauthbearer.internals.OAuthBearerClientInitialResponse;
import org.apache.kafkaesque.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerSaslServer
implements SaslServer {
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerSaslServer.class);
    private static final String NEGOTIATED_PROPERTY_KEY_TOKEN = "OAUTHBEARER.token";
    private static final String INTERNAL_ERROR_ON_SERVER = "Authentication could not be performed due to an internal error on the server";
    private final AuthenticateCallbackHandler callbackHandler;
    private boolean complete;
    private OAuthBearerToken tokenForNegotiatedProperty = null;
    private String errorMessage = null;
    private SaslExtensions extensions;

    public OAuthBearerSaslServer(CallbackHandler callbackHandler) {
        if (!(Objects.requireNonNull(callbackHandler) instanceof AuthenticateCallbackHandler)) {
            throw new IllegalArgumentException(String.format("Callback handler must be castable to %s: %s", AuthenticateCallbackHandler.class.getName(), callbackHandler.getClass().getName()));
        }
        this.callbackHandler = (AuthenticateCallbackHandler)callbackHandler;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException, SaslAuthenticationException {
        OAuthBearerClientInitialResponse clientResponse;
        if (response.length == 1 && response[0] == 1 && this.errorMessage != null) {
            log.debug("Received %x01 response from client after it received our error");
            throw new SaslAuthenticationException(this.errorMessage);
        }
        this.errorMessage = null;
        try {
            clientResponse = new OAuthBearerClientInitialResponse(response);
        }
        catch (SaslException e) {
            log.debug(e.getMessage());
            throw e;
        }
        return this.process(clientResponse.tokenValue(), clientResponse.authorizationId(), clientResponse.extensions());
    }

    @Override
    public String getAuthorizationID() {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return this.tokenForNegotiatedProperty.principalName();
    }

    @Override
    public String getMechanismName() {
        return "OAUTHBEARER";
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        if (NEGOTIATED_PROPERTY_KEY_TOKEN.equals(propName)) {
            return this.tokenForNegotiatedProperty;
        }
        if ("CREDENTIAL.LIFETIME.MS".equals(propName)) {
            return this.tokenForNegotiatedProperty.lifetimeMs();
        }
        return this.extensions.map().get(propName);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(incoming, offset, offset + len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) {
        if (!this.complete) {
            throw new IllegalStateException("Authentication exchange has not completed");
        }
        return Arrays.copyOfRange(outgoing, offset, offset + len);
    }

    @Override
    public void dispose() {
        this.complete = false;
        this.tokenForNegotiatedProperty = null;
        this.extensions = null;
    }

    private byte[] process(String tokenValue, String authorizationId, SaslExtensions extensions) throws SaslException {
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(tokenValue);
        try {
            this.callbackHandler.handle(new Callback[]{callback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            this.handleCallbackError(e);
        }
        OAuthBearerToken token = callback.token();
        if (token == null) {
            this.errorMessage = OAuthBearerSaslServer.jsonErrorResponse(callback.errorStatus(), callback.errorScope(), callback.errorOpenIDConfiguration());
            log.debug(this.errorMessage);
            return this.errorMessage.getBytes(StandardCharsets.UTF_8);
        }
        if (!authorizationId.isEmpty() && !authorizationId.equals(token.principalName())) {
            throw new SaslAuthenticationException(String.format("Authentication failed: Client requested an authorization id (%s) that is different from the token's principal name (%s)", authorizationId, token.principalName()));
        }
        Map<String, String> validExtensions = this.processExtensions(token, extensions);
        this.tokenForNegotiatedProperty = token;
        this.extensions = new SaslExtensions(validExtensions);
        this.complete = true;
        log.debug("Successfully authenticate User={}", (Object)token.principalName());
        return new byte[0];
    }

    private Map<String, String> processExtensions(OAuthBearerToken token, SaslExtensions extensions) throws SaslException {
        OAuthBearerExtensionsValidatorCallback extensionsCallback = new OAuthBearerExtensionsValidatorCallback(token, extensions);
        try {
            this.callbackHandler.handle(new Callback[]{extensionsCallback});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (IOException e) {
            this.handleCallbackError(e);
        }
        if (!extensionsCallback.invalidExtensions().isEmpty()) {
            String errorMessage = String.format("Authentication failed: %d extensions are invalid! They are: %s", extensionsCallback.invalidExtensions().size(), Utils.mkString(extensionsCallback.invalidExtensions(), "", "", ": ", "; "));
            log.debug(errorMessage);
            throw new SaslAuthenticationException(errorMessage);
        }
        return extensionsCallback.validatedExtensions();
    }

    private static String jsonErrorResponse(String errorStatus, String errorScope, String errorOpenIDConfiguration) {
        String jsonErrorResponse = String.format("{\"status\":\"%s\"", errorStatus);
        if (errorScope != null) {
            jsonErrorResponse = String.format("%s, \"scope\":\"%s\"", jsonErrorResponse, errorScope);
        }
        if (errorOpenIDConfiguration != null) {
            jsonErrorResponse = String.format("%s, \"openid-configuration\":\"%s\"", jsonErrorResponse, errorOpenIDConfiguration);
        }
        jsonErrorResponse = String.format("%s}", jsonErrorResponse);
        return jsonErrorResponse;
    }

    private void handleCallbackError(Exception e) throws SaslException {
        String msg = String.format("%s: %s", INTERNAL_ERROR_ON_SERVER, e.getMessage());
        log.debug(msg, (Throwable)e);
        throw new SaslException(msg);
    }

    public static String[] mechanismNamesCompatibleWithPolicy(Map<String, ?> props) {
        String[] stringArray;
        if (props != null && "true".equals(String.valueOf(props.get("javax.security.sasl.policy.noplaintext")))) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "OAUTHBEARER";
        }
        return stringArray;
    }

    public static class OAuthBearerSaslServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) {
            String[] mechanismNamesCompatibleWithPolicy = this.getMechanismNames(props);
            for (int i = 0; i < mechanismNamesCompatibleWithPolicy.length; ++i) {
                if (!mechanismNamesCompatibleWithPolicy[i].equals(mechanism)) continue;
                return new OAuthBearerSaslServer(callbackHandler);
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return OAuthBearerSaslServer.mechanismNamesCompatibleWithPolicy(props);
        }
    }
}

