/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

enum MetadataColumn {
    OFFSET("__offset", (TypeInfo)TypeInfoFactory.longTypeInfo),
    PARTITION("__partition", (TypeInfo)TypeInfoFactory.intTypeInfo),
    KEY("__key", (TypeInfo)TypeInfoFactory.binaryTypeInfo),
    TIMESTAMP("__timestamp", (TypeInfo)TypeInfoFactory.longTypeInfo);

    private static final List<MetadataColumn> KAFKA_METADATA_COLUMNS;
    static final List<ObjectInspector> KAFKA_METADATA_INSPECTORS;
    static final List<String> KAFKA_METADATA_COLUMN_NAMES;
    private final String name;
    private final TypeInfo typeInfo;
    private static final Map<String, MetadataColumn> NAMES_MAP;

    private MetadataColumn(String name, TypeInfo typeInfo) {
        this.name = name;
        this.typeInfo = typeInfo;
    }

    public String getName() {
        return this.name;
    }

    public AbstractPrimitiveWritableObjectInspector getObjectInspector() {
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)this.typeInfo.getTypeName()));
    }

    @Nullable
    static MetadataColumn forName(String name) {
        return NAMES_MAP.get(name);
    }

    static {
        KAFKA_METADATA_COLUMNS = Arrays.asList(KEY, PARTITION, OFFSET, TIMESTAMP);
        KAFKA_METADATA_INSPECTORS = KAFKA_METADATA_COLUMNS.stream().map(MetadataColumn::getObjectInspector).collect(Collectors.toList());
        KAFKA_METADATA_COLUMN_NAMES = KAFKA_METADATA_COLUMNS.stream().map(MetadataColumn::getName).collect(Collectors.toList());
        NAMES_MAP = Arrays.stream(MetadataColumn.values()).collect(Collectors.toMap(MetadataColumn::getName, Function.identity()));
    }
}

