/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.kafkaesqueesque.clients.consumer.KafkaConsumer;
import org.apache.kafkaesqueesque.common.PartitionInfo;
import org.apache.kafkaesqueesque.common.TopicPartition;

class KafkaStorageHandlerInfo
implements StorageHandlerInfo {
    private final String topic;
    private final Properties consumerProperties;

    KafkaStorageHandlerInfo(String topic, Properties consumerProperties) {
        this.topic = topic;
        this.consumerProperties = consumerProperties;
    }

    public String formatAsText() {
        KafkaConsumer consumer = new KafkaConsumer(this, this.consumerProperties){};
        try {
            List<PartitionInfo> partitionsInfo = consumer.partitionsFor(this.topic);
            List<TopicPartition> topicPartitions = partitionsInfo.stream().map(partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition())).collect(Collectors.toList());
            Map<TopicPartition, Long> endOffsets = consumer.endOffsets(topicPartitions);
            Map<TopicPartition, Long> startOffsets = consumer.beginningOffsets(topicPartitions);
            String string = partitionsInfo.stream().map(partitionInfo -> String.format("%s [start offset = [%s], end offset = [%s]]", partitionInfo.toString(), startOffsets.get(new TopicPartition(partitionInfo.topic(), partitionInfo.partition())), endOffsets.get(new TopicPartition(partitionInfo.topic(), partitionInfo.partition())))).collect(Collectors.joining("\n"));
            consumer.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    consumer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return String.format("ERROR fetching metadata for Topic [%s], Connection String [%s], Error [%s]", this.topic, this.consumerProperties.getProperty("bootstrap.servers"), e.getMessage());
            }
        }
    }
}

