/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafkaesqueesque.common.TopicPartition;
import org.apache.kafkaesqueesque.common.message.ElectLeadersResponseData;
import org.apache.kafkaesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesque.common.protocol.Errors;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.requests.AbstractResponse;

public class ElectLeadersResponse
extends AbstractResponse {
    private final short version;
    private final ElectLeadersResponseData data;

    public ElectLeadersResponse(Struct struct) {
        this(struct, ApiKeys.ELECT_LEADERS.latestVersion());
    }

    public ElectLeadersResponse(Struct struct, short version) {
        this.version = version;
        this.data = new ElectLeadersResponseData(struct, version);
    }

    public ElectLeadersResponse(int throttleTimeMs, short errorCode, List<ElectLeadersResponseData.ReplicaElectionResult> electionResults) {
        this(throttleTimeMs, errorCode, electionResults, ApiKeys.ELECT_LEADERS.latestVersion());
    }

    public ElectLeadersResponse(int throttleTimeMs, short errorCode, List<ElectLeadersResponseData.ReplicaElectionResult> electionResults, short version) {
        this.version = version;
        this.data = new ElectLeadersResponseData();
        this.data.setThrottleTimeMs(throttleTimeMs);
        if (version >= 1) {
            this.data.setErrorCode(errorCode);
        }
        this.data.setReplicaElectionResults(electionResults);
    }

    public ElectLeadersResponseData data() {
        return this.data;
    }

    public short version() {
        return this.version;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (ElectLeadersResponseData.ReplicaElectionResult result : this.data.replicaElectionResults()) {
            for (ElectLeadersResponseData.PartitionResult partitionResult : result.partitionResult()) {
                Errors error = Errors.forCode(partitionResult.errorCode());
                counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
            }
        }
        return counts;
    }

    public static ElectLeadersResponse parse(ByteBuffer buffer, short version) {
        return new ElectLeadersResponse(ApiKeys.ELECT_LEADERS.responseSchema(version).read(buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    public static Map<TopicPartition, Optional<Throwable>> electLeadersResult(ElectLeadersResponseData data) {
        HashMap<TopicPartition, Optional<Throwable>> map = new HashMap<TopicPartition, Optional<Throwable>>();
        for (ElectLeadersResponseData.ReplicaElectionResult topicResults : data.replicaElectionResults()) {
            for (ElectLeadersResponseData.PartitionResult partitionResult : topicResults.partitionResult()) {
                Optional<Object> value = Optional.empty();
                Errors error = Errors.forCode(partitionResult.errorCode());
                if (error != Errors.NONE) {
                    value = Optional.of(error.exception(partitionResult.errorMessage()));
                }
                map.put(new TopicPartition(topicResults.topic(), partitionResult.partitionId()), value);
            }
        }
        return map;
    }
}

