/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafkaesqueesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesqueesque.common.protocol.ApiMessage;
import org.apache.kafkaesqueesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesqueesque.common.protocol.Readable;
import org.apache.kafkaesqueesque.common.protocol.Writable;
import org.apache.kafkaesqueesque.common.protocol.types.Field;
import org.apache.kafkaesqueesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesqueesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesqueesque.common.protocol.types.Schema;
import org.apache.kafkaesqueesque.common.protocol.types.Struct;
import org.apache.kafkaesqueesque.common.protocol.types.Type;
import org.apache.kafkaesqueesque.common.utils.ByteUtils;
import org.apache.kafkaesqueesque.common.utils.Bytes;

public class SyncGroupResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private String protocolType;
    private String protocolName;
    private byte[] assignment;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("assignment", Type.BYTES, "The member assignment."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public SyncGroupResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SyncGroupResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public SyncGroupResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.protocolType = null;
        this.protocolName = null;
        this.assignment = Bytes.EMPTY;
    }

    @Override
    public short apiKey() {
        return 14;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int length;
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.errorCode = _readable.readShort();
        if (_version >= 5) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.protocolType = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field protocolType had invalid length " + length);
                }
                this.protocolType = _readable.readString(length);
            }
        } else {
            this.protocolType = null;
        }
        if (_version >= 5) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.protocolName = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field protocolName had invalid length " + length);
                }
                this.protocolName = _readable.readString(length);
            }
        } else {
            this.protocolName = null;
        }
        length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
        if (length < 0) {
            throw new RuntimeException("non-nullable field assignment was serialized as null");
        }
        byte[] newBytes = new byte[length];
        _readable.readArray(newBytes);
        this.assignment = newBytes;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeShort(this.errorCode);
        if (_version >= 5) {
            if (this.protocolType == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.protocolType);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        }
        if (_version >= 5) {
            if (this.protocolName == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.protocolName);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.assignment.length + 1);
        } else {
            _writable.writeInt(this.assignment.length);
        }
        _writable.writeByteArray(this.assignment);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        this.protocolType = _version >= 5 ? struct.getString("protocol_type") : null;
        this.protocolName = _version >= 5 ? struct.getString("protocol_name") : null;
        this.assignment = struct.getByteArray("assignment");
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        if (_version >= 5) {
            struct.set("protocol_type", (Object)this.protocolType);
        }
        if (_version >= 5) {
            struct.set("protocol_name", (Object)this.protocolName);
        }
        struct.setByteArray("assignment", this.assignment);
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 4;
        }
        _size += 2;
        if (_version >= 5) {
            if (this.protocolType == null) {
                ++_size;
            } else {
                _stringBytes = this.protocolType.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'protocolType' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.protocolType, _stringBytes);
                _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            }
        }
        if (_version >= 5) {
            if (this.protocolName == null) {
                ++_size;
            } else {
                _stringBytes = this.protocolName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'protocolName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.protocolName, _stringBytes);
                _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            }
        }
        int _bytesSize = this.assignment.length;
        _bytesSize = _version >= 4 ? (_bytesSize += ByteUtils.sizeOfUnsignedVarint(this.assignment.length + 1)) : (_bytesSize += 4);
        _size += _bytesSize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SyncGroupResponseData)) {
            return false;
        }
        SyncGroupResponseData other = (SyncGroupResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
            return false;
        }
        if (this.protocolName == null ? other.protocolName != null : !this.protocolName.equals(other.protocolName)) {
            return false;
        }
        return Arrays.equals(this.assignment, other.assignment);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        hashCode = 31 * hashCode + (this.protocolName == null ? 0 : this.protocolName.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.assignment);
        return hashCode;
    }

    public String toString() {
        return "SyncGroupResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", protocolType=" + (this.protocolType == null ? "null" : "'" + this.protocolType.toString() + "'") + ", protocolName=" + (this.protocolName == null ? "null" : "'" + this.protocolName.toString() + "'") + ", assignment=" + Arrays.toString(this.assignment) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public String protocolName() {
        return this.protocolName;
    }

    public byte[] assignment() {
        return this.assignment;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SyncGroupResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public SyncGroupResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public SyncGroupResponseData setProtocolType(String v) {
        this.protocolType = v;
        return this;
    }

    public SyncGroupResponseData setProtocolName(String v) {
        this.protocolName = v;
        return this;
    }

    public SyncGroupResponseData setAssignment(byte[] v) {
        this.assignment = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("assignment", Type.BYTES, "The member assignment.")));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("assignment", Type.COMPACT_BYTES, "The member assignment."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("protocol_type", Type.COMPACT_NULLABLE_STRING, "The group protocol type."), new Field("protocol_name", Type.COMPACT_NULLABLE_STRING, "The group protocol name."), new Field("assignment", Type.COMPACT_BYTES, "The member assignment."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }
}

