/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.clients.admin;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafkaesqueesque.clients.admin.ConsumerGroupListing;
import org.apache.kafkaesqueesque.common.KafkaFuture;
import org.apache.kafkaesqueesque.common.annotation.InterfaceStability;
import org.apache.kafkaesqueesque.common.internals.KafkaFutureImpl;

@InterfaceStability.Evolving
public class ListConsumerGroupsResult {
    private final KafkaFutureImpl<Collection<ConsumerGroupListing>> all = new KafkaFutureImpl();
    private final KafkaFutureImpl<Collection<ConsumerGroupListing>> valid = new KafkaFutureImpl();
    private final KafkaFutureImpl<Collection<Throwable>> errors = new KafkaFutureImpl();

    ListConsumerGroupsResult(KafkaFutureImpl<Collection<Object>> future) {
        future.thenApply(new KafkaFuture.BaseFunction<Collection<Object>, Void>(){

            @Override
            public Void apply(Collection<Object> results) {
                ArrayList<Throwable> curErrors = new ArrayList<Throwable>();
                ArrayList<ConsumerGroupListing> curValid = new ArrayList<ConsumerGroupListing>();
                for (Object resultObject : results) {
                    if (resultObject instanceof Throwable) {
                        curErrors.add((Throwable)resultObject);
                        continue;
                    }
                    curValid.add((ConsumerGroupListing)resultObject);
                }
                if (!curErrors.isEmpty()) {
                    ListConsumerGroupsResult.this.all.completeExceptionally((Throwable)curErrors.get(0));
                } else {
                    ListConsumerGroupsResult.this.all.complete(curValid);
                }
                ListConsumerGroupsResult.this.valid.complete(curValid);
                ListConsumerGroupsResult.this.errors.complete(curErrors);
                return null;
            }
        });
    }

    public KafkaFuture<Collection<ConsumerGroupListing>> all() {
        return this.all;
    }

    public KafkaFuture<Collection<ConsumerGroupListing>> valid() {
        return this.valid;
    }

    public KafkaFuture<Collection<Throwable>> errors() {
        return this.errors;
    }
}

