/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.clients;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafkaesqueesque.clients.NodeApiVersions;
import org.apache.kafkaesqueesque.common.protocol.ApiKeys;
import org.apache.kafkaesqueesque.common.requests.ProduceRequest;

public class ApiVersions {
    private final Map<String, NodeApiVersions> nodeApiVersions = new HashMap<String, NodeApiVersions>();
    private byte maxUsableProduceMagic = (byte)2;

    public synchronized void update(String nodeId, NodeApiVersions nodeApiVersions) {
        this.nodeApiVersions.put(nodeId, nodeApiVersions);
        this.maxUsableProduceMagic = this.computeMaxUsableProduceMagic();
    }

    public synchronized void remove(String nodeId) {
        this.nodeApiVersions.remove(nodeId);
        this.maxUsableProduceMagic = this.computeMaxUsableProduceMagic();
    }

    public synchronized NodeApiVersions get(String nodeId) {
        return this.nodeApiVersions.get(nodeId);
    }

    private byte computeMaxUsableProduceMagic() {
        byte maxUsableMagic = 2;
        for (NodeApiVersions versions : this.nodeApiVersions.values()) {
            byte nodeMaxUsableMagic = ProduceRequest.requiredMagicForVersion(versions.latestUsableVersion(ApiKeys.PRODUCE));
            maxUsableMagic = (byte)Math.min(nodeMaxUsableMagic, maxUsableMagic);
        }
        return maxUsableMagic;
    }

    public synchronized byte maxUsableProduceMagic() {
        return this.maxUsableProduceMagic;
    }
}

