/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;

public abstract class ColumnStatsAggregator {
    public boolean useDensityFunctionForNDVEstimation;
    public double ndvTuner;

    public abstract ColumnStatisticsObj aggregate(List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> var1, List<String> var2, boolean var3) throws MetaException;

    void checkStatisticsList(List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo) {
        if (colStatsWithSourceInfo.isEmpty()) {
            throw new IllegalArgumentException("Column statistics list must not be empty when aggregating");
        }
    }

    protected abstract ColumnStatisticsData initColumnStatisticsData();

    protected KllHistogramEstimator mergeHistograms(List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> colStatsWithSourceInfo) {
        ArrayList<KllHistogramEstimator> mergedHistogramEstimators = new ArrayList<KllHistogramEstimator>();
        BitSet mergedStats = new BitSet(colStatsWithSourceInfo.size());
        int currIndex = 0;
        while (mergedStats.cardinality() != colStatsWithSourceInfo.size()) {
            ColumnStatisticsObj currColStatsObj = colStatsWithSourceInfo.get(currIndex = mergedStats.nextClearBit(currIndex)).getColStatsObj();
            KllHistogramEstimator statsEstimator = this.getHistogramFromStats(currColStatsObj);
            if (statsEstimator == null) {
                mergedStats.set(currIndex);
                continue;
            }
            KllHistogramEstimator currHistogram = KllHistogramEstimatorFactory.getEmptyHistogramEstimator(statsEstimator);
            currHistogram.mergeEstimators(statsEstimator);
            for (KllHistogramEstimator candidateHistogram : mergedHistogramEstimators) {
                if (!candidateHistogram.canMerge(currHistogram)) continue;
                candidateHistogram.mergeEstimators(currHistogram);
                mergedStats.set(currIndex);
                break;
            }
            if (mergedStats.get(currIndex)) continue;
            mergedHistogramEstimators.add(currHistogram);
            mergedStats.set(currIndex);
        }
        long biggestN = -1L;
        KllHistogramEstimator largestHistogramEstimator = null;
        for (KllHistogramEstimator hist : mergedHistogramEstimators) {
            if (hist.getSketch().getN() <= biggestN) continue;
            biggestN = hist.getSketch().getN();
            largestHistogramEstimator = hist;
        }
        return largestHistogramEstimator;
    }

    private KllHistogramEstimator getHistogramFromStats(ColumnStatisticsObj currColStatsObj) {
        ColumnStatisticsData columnStatisticsData = currColStatsObj.getStatsData();
        if (columnStatisticsData.isSetDateStats()) {
            return ColumnsStatsUtils.dateInspectorFromStats(currColStatsObj).getHistogramEstimator();
        }
        if (columnStatisticsData.isSetDecimalStats()) {
            return ColumnsStatsUtils.decimalInspectorFromStats(currColStatsObj).getHistogramEstimator();
        }
        if (columnStatisticsData.isSetDoubleStats()) {
            return ColumnsStatsUtils.doubleInspectorFromStats(currColStatsObj).getHistogramEstimator();
        }
        if (columnStatisticsData.isSetLongStats()) {
            return ColumnsStatsUtils.longInspectorFromStats(currColStatsObj).getHistogramEstimator();
        }
        if (columnStatisticsData.isSetTimestampStats()) {
            return ColumnsStatsUtils.timestampInspectorFromStats(currColStatsObj).getHistogramEstimator();
        }
        throw new IllegalArgumentException(currColStatsObj.getColType() + " is not supported for merging column stats histograms");
    }
}

