/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class OpenTxnTimeoutLowBoundaryTxnIdHandler
implements QueryHandler<Long> {
    private final long openTxnTimeOutMillis;

    public OpenTxnTimeoutLowBoundaryTxnIdHandler(long openTxnTimeOutMillis) {
        this.openTxnTimeOutMillis = openTxnTimeOutMillis;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT MAX(\"TXN_ID\") FROM \"TXNS\" WHERE \"TXN_STARTED\" < (" + TxnUtils.getEpochFn(databaseProduct) + " - " + this.openTxnTimeOutMillis + ")";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource();
    }

    public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
        rs.next();
        long result = rs.getLong(1);
        if (rs.wasNull()) {
            throw new SQLException("Transaction tables not properly initialized, null record found in MAX(TXN_ID)");
        }
        return result;
    }
}

