/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.Collections;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSchemasOperation
extends MetadataOperation {
    private static final Logger LOG = LoggerFactory.getLogger((String)GetSchemasOperation.class.getName());
    private final String catalogName;
    private final String schemaName;
    private static final TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_SCHEM", "Schema name.").addStringColumn("TABLE_CATALOG", "Catalog name.");
    private RowSet rowSet;

    protected GetSchemasOperation(HiveSession parentSession, String catalogName, String schemaName) {
        super(parentSession, OperationType.GET_SCHEMAS);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.rowSet = RowSetFactory.create(RESULT_SET_SCHEMA, this.getProtocolVersion(), false);
        LOG.info("Starting GetSchemasOperation with the following parameters: catalogName={}, schemaName={}", (Object)catalogName, (Object)schemaName);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        LOG.info("Fetching schema metadata");
        if (this.isAuthV2Enabled()) {
            String cmdStr = "catalog : " + this.catalogName + ", schemaPattern : " + this.schemaName;
            this.authorizeMetaGets(HiveOperationType.GET_SCHEMAS, null, cmdStr);
        }
        try {
            IMetaStoreClient metastoreClient = this.getParentSession().getMetaStoreClient();
            String schemaPattern = this.convertSchemaPattern(this.schemaName);
            for (String dbName : metastoreClient.getDatabases(schemaPattern)) {
                this.rowSet.addRow(new Object[]{dbName, ""});
                if (!LOG.isDebugEnabled()) continue;
                String debugMessage = this.getDebugMessage("schema", RESULT_SET_SCHEMA);
                LOG.debug(debugMessage, (Object)dbName, (Object)"");
            }
            if (LOG.isDebugEnabled() && this.rowSet.numRows() == 0) {
                LOG.debug("No schema metadata has been returned.");
            }
            this.setState(OperationState.FINISHED);
            LOG.info("Fetching schema metadata has been successfully finished");
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException(e);
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(Collections.singleton(OperationState.FINISHED));
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(Collections.singleton(OperationState.FINISHED));
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }
}

