/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.Service;
import org.apache.hive.service.ServiceOperations;
import org.apache.hive.service.ServiceStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractService.class);
    private Service.STATE state = Service.STATE.NOTINITED;
    private final String name;
    private long startTime;
    private HiveConf hiveConf;
    private final List<ServiceStateChangeListener> listeners = new ArrayList<ServiceStateChangeListener>();

    public AbstractService(String name) {
        this.name = name;
    }

    @Override
    public synchronized Service.STATE getServiceState() {
        return this.state;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.ensureCurrentState(Service.STATE.NOTINITED);
        this.setHiveConf(hiveConf);
        this.changeState(Service.STATE.INITED);
        LOG.info("Service:" + this.getName() + " is inited.");
    }

    protected final void setHiveConf(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    @Override
    public synchronized void start() {
        this.startTime = System.currentTimeMillis();
        this.ensureCurrentState(Service.STATE.INITED);
        this.changeState(Service.STATE.STARTED);
        LOG.info("Service:" + this.getName() + " is started.");
    }

    @Override
    public synchronized void decommission() {
        if (this.state == Service.STATE.STOPPED || this.state == Service.STATE.INITED || this.state == Service.STATE.NOTINITED || this.state == Service.STATE.DECOMMISSIONING) {
            return;
        }
        this.ensureCurrentState(Service.STATE.STARTED);
        this.changeState(Service.STATE.DECOMMISSIONING);
        LOG.info("Service:" + this.getName() + " is decommissioning.");
    }

    @Override
    public synchronized void stop() {
        if (this.state == Service.STATE.STOPPED || this.state == Service.STATE.INITED || this.state == Service.STATE.NOTINITED) {
            return;
        }
        if (this.state != Service.STATE.DECOMMISSIONING && this.state != Service.STATE.STARTED) {
            throw new IllegalStateException("For stop operation, the current service state must be " + String.valueOf((Object)Service.STATE.DECOMMISSIONING) + " or " + String.valueOf((Object)Service.STATE.STARTED) + " instead of " + String.valueOf((Object)this.state));
        }
        this.changeState(Service.STATE.STOPPED);
        LOG.info("Service:" + this.getName() + " is stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ServiceStateChangeListener l) {
        List<ServiceStateChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(ServiceStateChangeListener l) {
        List<ServiceStateChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    private void ensureCurrentState(Service.STATE currentState) {
        ServiceOperations.ensureCurrentState(this.state, currentState);
    }

    private void changeState(Service.STATE newState) {
        this.state = newState;
        for (ServiceStateChangeListener l : this.listeners) {
            l.stateChanged(this);
        }
    }
}

