/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.PartitionManagementTask;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.tools.BenchData;
import org.apache.hadoop.hive.metastore.tools.BenchmarkUtils;
import org.apache.hadoop.hive.metastore.tools.HMSClient;
import org.apache.hadoop.hive.metastore.tools.MicroBenchmark;
import org.apache.hadoop.hive.metastore.tools.Util;
import org.apache.thrift.TException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HMSBenchmarks {
    private static final Logger LOG = LoggerFactory.getLogger(HMSBenchmarks.class);
    private static final String PARAM_KEY = "parameter_";
    private static final String PARAM_VALUE = "value_";

    HMSBenchmarks() {
    }

    static DescriptiveStatistics benchmarkListDatabases(@NotNull MicroBenchmark benchmark, @NotNull BenchData data) {
        HMSClient client = data.getClient();
        return benchmark.measure(() -> Util.throwingSupplierWrapper(() -> client.getAllDatabases(null)));
    }

    static DescriptiveStatistics benchmarkListAllTables(@NotNull MicroBenchmark benchmark, @NotNull BenchData data) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        return benchmark.measure(() -> Util.throwingSupplierWrapper(() -> client.getAllTables(dbName, null)));
    }

    static DescriptiveStatistics benchmarkTableCreate(@NotNull MicroBenchmark bench, @NotNull BenchData data) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        Table table = Util.TableBuilder.buildDefaultTable((String)dbName, (String)tableName);
        return bench.measure(null, () -> Util.throwingSupplierWrapper(() -> client.createTable(table)), () -> Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName)));
    }

    static DescriptiveStatistics benchmarkDeleteCreate(@NotNull MicroBenchmark bench, @NotNull BenchData data) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        Table table = Util.TableBuilder.buildDefaultTable((String)dbName, (String)tableName);
        return bench.measure(() -> Util.throwingSupplierWrapper(() -> client.createTable(table)), () -> Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName)), null);
    }

    static DescriptiveStatistics benchmarkDeleteWithPartitions(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany, int nparams) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        HashMap<CallSite, CallSite> parameters = new HashMap<CallSite, CallSite>(nparams);
        for (int i = 0; i < nparams; ++i) {
            parameters.put((CallSite)((Object)(PARAM_KEY + i)), (CallSite)((Object)(PARAM_VALUE + i)));
        }
        return bench.measure(() -> Util.throwingSupplierWrapper(() -> {
            BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
            Util.addManyPartitions((HMSClient)client, (String)dbName, (String)tableName, (Map)parameters, Collections.singletonList("d"), (int)howMany);
            return true;
        }), () -> Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName)), null);
    }

    static DescriptiveStatistics benchmarkDeleteMetaOnlyWithPartitions(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany, int nparams) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        HashMap<CallSite, CallSite> parameters = new HashMap<CallSite, CallSite>(nparams);
        for (int i = 0; i < nparams; ++i) {
            parameters.put((CallSite)((Object)(PARAM_KEY + i)), (CallSite)((Object)(PARAM_VALUE + i)));
        }
        return bench.measure(() -> Util.throwingSupplierWrapper(() -> {
            BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
            Util.addManyPartitions((HMSClient)client, (String)dbName, (String)tableName, (Map)parameters, Collections.singletonList("d"), (int)howMany);
            return true;
        }), () -> Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName, false)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkGetTable(@NotNull MicroBenchmark bench, @NotNull BenchData data) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.getTable(dbName, tableName)));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkListTables(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String format = "tmp_table_%d";
        try {
            BenchmarkUtils.createManyTables(client, count, dbName, format);
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.getAllTables(dbName, null)));
            return descriptiveStatistics;
        }
        finally {
            BenchmarkUtils.dropManyTables(client, count, dbName, format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkCreatePartition(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Table t = client.getTable(dbName, tableName);
            List parts = Util.createManyPartitions((Table)t, null, Collections.singletonList("d"), (int)howMany);
            DescriptiveStatistics descriptiveStatistics = bench.measure(null, () -> Util.throwingSupplierWrapper(() -> {
                parts.forEach(part -> Util.throwingSupplierWrapper(() -> client.addPartition(part)));
                return null;
            }), () -> Util.throwingSupplierWrapper(() -> client.dropPartitions(dbName, tableName, null)));
            return descriptiveStatistics;
        }
        catch (TException e) {
            e.printStackTrace();
            DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkListPartition(@NotNull MicroBenchmark bench, @NotNull BenchData data) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitions((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)1);
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.listPartitions(dbName, tableName)));
            return descriptiveStatistics;
        }
        catch (TException e) {
            e.printStackTrace();
            DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkListManyPartitions(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitions((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)howMany);
            LOG.debug("Created {} partitions", (Object)howMany);
            LOG.debug("started benchmark... ");
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.listPartitions(dbName, tableName)));
            return descriptiveStatistics;
        }
        catch (TException e) {
            e.printStackTrace();
            DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkGetPartitions(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitions((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)howMany);
            LOG.debug("Created {} partitions", (Object)howMany);
            LOG.debug("started benchmark... ");
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.getPartitions(dbName, tableName)));
            return descriptiveStatistics;
        }
        catch (TException e) {
            e.printStackTrace();
            DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkDropPartition(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count), () -> Util.throwingSupplierWrapper(() -> {
                List partNames = client.getPartitionNames(dbName, tableName);
                partNames.forEach(partName -> Util.throwingSupplierWrapper(() -> client.dropPartition(dbName, tableName, partName)));
                return null;
            }), null);
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkCreatePartitions(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            DescriptiveStatistics descriptiveStatistics = bench.measure(null, () -> Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count), () -> Util.throwingSupplierWrapper(() -> client.dropPartitions(dbName, tableName, null)));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkDropPartitions(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count), () -> Util.throwingSupplierWrapper(() -> client.dropPartitions(dbName, tableName, null)), null);
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkAlterPartitions(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count), () -> Util.throwingSupplierWrapper(() -> {
                List newPartitions = client.getPartitions(dbName, tableName);
                newPartitions.forEach(p -> {
                    p.getParameters().put("new_param", "param_val");
                    p.getSd().setCols(Arrays.asList(new FieldSchema("new_col", "string", null)));
                });
                client.alterPartitions(dbName, tableName, newPartitions);
                return null;
            }), () -> Util.throwingSupplierWrapper(() -> client.dropPartitions(dbName, tableName, null)));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkGetPartitionNames(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count);
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.getPartitionNames(dbName, tableName)));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkGetPartitionsByName(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count);
            List partitionNames = (List)Util.throwingSupplierWrapper(() -> client.getPartitionNames(dbName, tableName));
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.getPartitionsByNames(dbName, tableName, partitionNames)));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkGetPartitionsByFilter(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName, Util.createSchema(Arrays.asList("p_a", "p_b", "p_c")));
        try {
            Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Arrays.asList("a", "b", "c"), (int)count);
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> {
                client.getPartitionsByFilter(dbName, tableName, "`p_a`='a0'");
                client.getPartitionsByFilter(dbName, tableName, "`p_a`='a0' or `p_b`='b0' or `p_c`='c0' or `p_a`='a1' or `p_b`='b1' or `p_c`='c1'");
                return null;
            }));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkGetPartitionsByPs(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName, Util.createSchema(Arrays.asList("p_a", "p_b", "p_c")));
        try {
            List values = IntStream.range(0, count).mapToObj(i -> Arrays.asList("a0", "b" + i, "c" + i)).collect(Collectors.toList());
            Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, values);
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.getPartitionsByPs(dbName, tableName, Arrays.asList("a0"))));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkGetPartitionsStat(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count);
            List partNames = (List)Util.throwingSupplierWrapper(() -> client.getPartitionNames(dbName, tableName));
            Util.updateManyPartitionsStatsNoException((HMSClient)client, (String)dbName, (String)tableName, (List)partNames);
            PartitionsStatsRequest request = new PartitionsStatsRequest(dbName, tableName, Arrays.asList("name"), partNames);
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.throwingSupplierWrapper(() -> client.getPartitionsStats(request)));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkUpdatePartitionsStat(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count);
            List partNames = (List)Util.throwingSupplierWrapper(() -> client.getPartitionNames(dbName, tableName));
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> Util.updateManyPartitionsStatsNoException((HMSClient)client, (String)dbName, (String)tableName, (List)partNames));
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkRenameTable(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        String tableName = data.tableName;
        BenchmarkUtils.createPartitionedTable(client, dbName, tableName);
        try {
            Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)count);
            Table oldTable = client.getTable(dbName, tableName);
            oldTable.getSd().setLocation("");
            Table newTable = oldTable.deepCopy();
            newTable.setTableName(tableName + "_renamed");
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> {
                Util.throwingSupplierWrapper(() -> client.alterTable(oldTable.getDbName(), oldTable.getTableName(), newTable));
                Util.throwingSupplierWrapper(() -> client.alterTable(newTable.getDbName(), newTable.getTableName(), oldTable));
            });
            return descriptiveStatistics;
        }
        catch (TException e) {
            e.printStackTrace();
            DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.dropTable(dbName, tableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkDropDatabase(@NotNull MicroBenchmark bench, @NotNull BenchData data, int count) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        Util.throwingSupplierWrapper(() -> client.dropDatabase(dbName));
        try {
            DescriptiveStatistics descriptiveStatistics = bench.measure(() -> {
                Util.throwingSupplierWrapper(() -> client.createDatabase(dbName));
                BenchmarkUtils.createManyTables(client, count, dbName, "tmp_table_%d");
            }, () -> Util.throwingSupplierWrapper(() -> client.dropDatabase(dbName)), null);
            return descriptiveStatistics;
        }
        finally {
            Util.throwingSupplierWrapper(() -> client.createDatabase(dbName));
        }
    }

    static DescriptiveStatistics benchmarkOpenTxns(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany) {
        HMSClient client = data.getClient();
        return bench.measure(null, () -> Util.throwingSupplierWrapper(() -> client.openTxn(howMany)), () -> Util.throwingSupplierWrapper(() -> client.abortTxns(client.getOpenTxns())));
    }

    static DescriptiveStatistics benchmarkAllocateTableWriteIds(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany) {
        HMSClient client = data.getClient();
        return bench.measure(() -> Util.throwingSupplierWrapper(() -> client.openTxn(howMany)), () -> Util.throwingSupplierWrapper(() -> client.allocateTableWriteIds("test_db", "test_tbl", client.getOpenTxns())), () -> Util.throwingSupplierWrapper(() -> client.abortTxns(client.getOpenTxns())));
    }

    static DescriptiveStatistics benchmarkGetValidWriteIds(@NotNull MicroBenchmark bench, @NotNull BenchData data, int howMany) {
        HMSClient client = data.getClient();
        String dbName = data.dbName;
        ArrayList tableNames = new ArrayList();
        return bench.measure(() -> {
            BenchmarkUtils.createManyTables(client, howMany, dbName, "tmp_table_%d");
            for (int i = 0; i < howMany; ++i) {
                tableNames.add(dbName + ".tmp_table_" + i);
            }
        }, () -> Util.throwingSupplierWrapper(() -> client.getValidWriteIds(tableNames)), () -> BenchmarkUtils.dropManyTables(client, howMany, dbName, "tmp_table_%d"));
    }

    static DescriptiveStatistics benchmarkGetNotificationId(@NotNull MicroBenchmark benchmark, @NotNull BenchData data) {
        HMSClient client = data.getClient();
        return benchmark.measure(() -> Util.throwingSupplierWrapper(() -> ((HMSClient)client).getCurrentNotificationId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DescriptiveStatistics benchmarkPartitionManagement(@NotNull MicroBenchmark bench, @NotNull BenchData data, int tableCount) {
        FileSystem fs;
        String dbName = data.dbName + "_" + tableCount;
        String tableNamePrefix = data.tableName;
        HMSClient client = data.getClient();
        PartitionManagementTask partitionManagementTask = new PartitionManagementTask();
        ArrayList<Path> paths = new ArrayList<Path>();
        try {
            fs = FileSystem.get((Configuration)client.getHadoopConf());
            client.getHadoopConf().set("hive.metastore.uris", client.getServerURI().toString());
            client.getHadoopConf().set("metastore.partition.management.database.pattern", dbName);
            partitionManagementTask.setConf(client.getHadoopConf());
            client.createDatabase(dbName);
            for (int i = 0; i < tableCount; ++i) {
                boolean enableDynamicPart;
                String tableName = tableNamePrefix + "_" + i;
                Util.TableBuilder tableBuilder = new Util.TableBuilder(dbName, tableName).withType(TableType.MANAGED_TABLE).withColumns(Util.createSchema(Arrays.asList("astring:string", "aint:int", "adouble:double", "abigint:bigint"))).withPartitionKeys(Util.createSchema(Collections.singletonList("d")));
                boolean bl = enableDynamicPart = i % 5 == 0;
                if (enableDynamicPart) {
                    tableBuilder.withParameter("discover.partitions", "true");
                }
                client.createTable(tableBuilder.build());
                Util.addManyPartitionsNoException((HMSClient)client, (String)dbName, (String)tableName, null, Collections.singletonList("d"), (int)500);
                if (!enableDynamicPart) continue;
                Table t = client.getTable(dbName, tableName);
                Path tabLoc = new Path(t.getSd().getLocation());
                for (int j = 501; j <= 1000; ++j) {
                    Path path = new Path(tabLoc, "d=d" + j + "_1");
                    paths.add(path);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AtomicLong id = new AtomicLong(0L);
        ExecutorService service = Executors.newFixedThreadPool(20);
        Runnable preRun = () -> {
            int len = paths.size() / 20;
            id.getAndIncrement();
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            int i = 0;
            while (i <= 20) {
                int n = i++;
                futures.add(service.submit(() -> {
                    for (int j = k * len; j < (k + 1) * len && j < paths.size(); ++j) {
                        Path path = (Path)paths.get(j);
                        if (id.get() == 1L) {
                            fs.mkdirs(path);
                            continue;
                        }
                        String fileName = path.getName().split("_")[0];
                        long seq = id.get();
                        Path destPath = new Path(path.getParent(), fileName + "_" + seq);
                        Path sourcePath = new Path(path.getParent(), fileName + "_" + (seq - 1L));
                        fs.rename(sourcePath, destPath);
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    service.shutdown();
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            DescriptiveStatistics descriptiveStatistics = bench.measure(preRun, (Runnable)partitionManagementTask, null);
            return descriptiveStatistics;
        }
        finally {
            service.shutdown();
        }
    }
}

