/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.hive.metastore.tools.ACIDBenchmarks;
import org.apache.hadoop.hive.metastore.tools.BenchData;
import org.apache.hadoop.hive.metastore.tools.BenchmarkSuite;
import org.apache.hadoop.hive.metastore.tools.HMSBenchmarks;
import org.apache.hadoop.hive.metastore.tools.HMSClient;
import org.apache.hadoop.hive.metastore.tools.HMSConfig;
import org.apache.hadoop.hive.metastore.tools.MicroBenchmark;
import org.apache.hadoop.hive.metastore.tools.Util;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="BenchmarkTool", mixinStandardHelpOptions=true, version={"1.0"}, showDefaultValues=true)
public class BenchmarkTool
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(BenchmarkTool.class);
    private static final TimeUnit scale = TimeUnit.MILLISECONDS;
    private static final String CSV_SEPARATOR = "\t";
    private static final String TEST_TABLE = "bench_table";
    @CommandLine.Option(names={"-H", "--host"}, description={"HMS Host"}, paramLabel="URI")
    private String host;
    @CommandLine.Option(names={"-P", "--port"}, description={"HMS Server port"})
    private Integer port = 9083;
    @CommandLine.Option(names={"-d", "--db"}, description={"database name"})
    private String dbName = "bench_" + System.getProperty("user.name");
    @CommandLine.Option(names={"-t", "--table"}, description={"table name"})
    private String tableName = "bench_table_" + System.getProperty("user.name");
    @CommandLine.Option(names={"-N", "--number"}, description={"number of object instances"})
    private int[] instances = new int[]{100};
    @CommandLine.Option(names={"-L", "--spin"}, description={"spin count"})
    private int spinCount = 100;
    @CommandLine.Option(names={"-W", "--warmup"}, description={"warmup count"})
    private int warmup = 15;
    @CommandLine.Option(names={"-l", "--list"}, description={"list matching benchmarks"})
    private boolean doList = false;
    @CommandLine.Option(names={"-o", "--output"}, description={"output file"})
    private String outputFile;
    @CommandLine.Option(names={"-T", "--threads"}, description={"number of concurrent threads/clients"})
    private int nThreads = 2;
    @CommandLine.Option(names={"--confdir"}, description={"configuration directory"})
    private String confDir;
    @CommandLine.Option(names={"--sanitize"}, description={"sanitize results (remove outliers)"})
    private boolean doSanitize = false;
    @CommandLine.Option(names={"-C", "--csv"}, description={"produce CSV output"})
    private boolean doCSV = false;
    @CommandLine.Option(names={"--params"}, description={"number of table/partition parameters"})
    private int[] nParameters = new int[]{0};
    @CommandLine.Option(names={"--savedata"}, description={"save raw data in specified dir"})
    private String dataSaveDir;
    @CommandLine.Option(names={"--separator"}, description={"CSV field separator"})
    private String csvSeparator = "\t";
    @CommandLine.Option(names={"-M", "--pattern"}, description={"test name patterns"})
    private Pattern[] matches;
    @CommandLine.Option(names={"-E", "--exclude"}, description={"test name patterns to exclude"})
    private Pattern[] exclude;
    @CommandLine.Option(names={"--runMode"}, description={"flag for setting the mode for the benchmark, acceptable values are: ACID, NONACID, ALL, MSCK"})
    private RunModes runMode = RunModes.ALL;

    public static void main(String[] args) {
        CommandLine.run((Runnable)new BenchmarkTool(), (String[])args);
    }

    static void saveData(Map<String, DescriptiveStatistics> result, String location, TimeUnit scale) throws IOException {
        Path dir = Paths.get(location, new String[0]);
        if (!dir.toFile().exists()) {
            LOG.debug("creating directory {}", (Object)location);
            Files.createDirectories(dir, new FileAttribute[0]);
        } else if (!dir.toFile().isDirectory()) {
            LOG.error("{} should be a directory", (Object)location);
        }
        result.forEach((name, data) -> BenchmarkTool.saveDataFile(location, name, data, scale));
    }

    private static void saveDataFile(String location, String name, DescriptiveStatistics data, TimeUnit scale) {
        long conv = scale.toNanos(1L);
        Path dst = Paths.get(location, name);
        try (PrintStream output = new PrintStream(dst.toString());){
            Arrays.stream(data.getValues()).forEach(d -> output.println(d / (double)conv));
        }
        catch (FileNotFoundException e) {
            LOG.error("failed to write to {}", (Object)dst);
        }
    }

    @Override
    public void run() {
        LOG.info("Using warmup " + this.warmup + " spin " + this.spinCount + " nparams " + Arrays.toString(this.nParameters) + " threads " + this.nThreads);
        HMSConfig.getInstance().init(this.host, this.port, this.confDir);
        this.preRunMsck(this.runMode == RunModes.MSCK);
        switch (this.runMode) {
            case ACID: {
                this.runAcidBenchmarks();
                break;
            }
            case MSCK: 
            case NONACID: {
                this.runNonAcidBenchmarks();
                break;
            }
            default: {
                this.runNonAcidBenchmarks();
                this.runAcidBenchmarks();
            }
        }
    }

    private void preRunMsck(boolean isMsck) {
        if (isMsck) {
            this.matches = new Pattern[]{Pattern.compile("PartitionManagementTask.*")};
        } else {
            ArrayList<Pattern> excludes = new ArrayList<Pattern>();
            Optional.ofNullable(this.exclude).ifPresent(patterns -> Arrays.stream(patterns).forEach(p -> excludes.add((Pattern)p)));
            excludes.add(Pattern.compile("PartitionManagementTask.*"));
            this.exclude = excludes.toArray(new Pattern[0]);
        }
    }

    private void runAcidBenchmarks() {
        ChainedOptionsBuilder optsBuilder = new OptionsBuilder().warmupIterations(this.warmup).measurementIterations(this.spinCount).operationsPerInvocation(1).mode(Mode.SingleShotTime).timeUnit(TimeUnit.MILLISECONDS).forks(0).threads(this.nThreads).syncIterations(true);
        String[] candidates = new String[]{ACIDBenchmarks.TestOpenTxn.class.getSimpleName(), ACIDBenchmarks.TestLocking.class.getSimpleName(), ACIDBenchmarks.TestGetValidWriteIds.class.getSimpleName(), ACIDBenchmarks.TestAllocateTableWriteIds.class.getSimpleName()};
        for (String pattern : Util.filterMatches(Arrays.asList(candidates), (Pattern[])this.matches, (Pattern[])this.exclude)) {
            optsBuilder = optsBuilder.include(pattern);
        }
        Options opts = optsBuilder.param("howMany", (String[])Arrays.stream(this.instances).mapToObj(String::valueOf).toArray(String[]::new)).param("nPartitions", (String[])Arrays.stream(this.nParameters).mapToObj(String::valueOf).toArray(String[]::new)).build();
        try {
            new Runner(opts).run();
        }
        catch (RunnerException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void runNonAcidBenchmarks() {
        StringBuilder sb = new StringBuilder();
        BenchData bData = new BenchData(this.dbName, this.tableName);
        MicroBenchmark bench = new MicroBenchmark(this.warmup, this.spinCount);
        BenchmarkSuite suite = new BenchmarkSuite();
        suite.setScale(scale).doSanitize(this.doSanitize).add("getNid", () -> HMSBenchmarks.benchmarkGetNotificationId(bench, bData)).add("listDatabases", () -> HMSBenchmarks.benchmarkListDatabases(bench, bData)).add("listTables", () -> HMSBenchmarks.benchmarkListAllTables(bench, bData)).add("getTable", () -> HMSBenchmarks.benchmarkGetTable(bench, bData)).add("createTable", () -> HMSBenchmarks.benchmarkTableCreate(bench, bData)).add("dropTable", () -> HMSBenchmarks.benchmarkDeleteCreate(bench, bData)).add("dropTableWithPartitions", () -> HMSBenchmarks.benchmarkDeleteWithPartitions(bench, bData, 1, this.nParameters[0])).add("dropTableMetadataWithPartitions", () -> HMSBenchmarks.benchmarkDeleteMetaOnlyWithPartitions(bench, bData, 1, this.nParameters[0])).add("addPartition", () -> HMSBenchmarks.benchmarkCreatePartition(bench, bData, 1)).add("dropPartition", () -> HMSBenchmarks.benchmarkDropPartition(bench, bData, 1)).add("listPartition", () -> HMSBenchmarks.benchmarkListPartition(bench, bData)).add("getPartition", () -> HMSBenchmarks.benchmarkGetPartitions(bench, bData, 1)).add("getPartitionNames", () -> HMSBenchmarks.benchmarkGetPartitionNames(bench, bData, 1)).add("getPartitionsByNames", () -> HMSBenchmarks.benchmarkGetPartitionsByName(bench, bData, 1)).add("getPartitionsByFilter", () -> HMSBenchmarks.benchmarkGetPartitionsByFilter(bench, bData, 1)).add("getPartitionsByPs", () -> HMSBenchmarks.benchmarkGetPartitionsByPs(bench, bData, 1)).add("getPartitionsStat", () -> HMSBenchmarks.benchmarkGetPartitionsStat(bench, bData, 1)).add("updatePartitionsStat", () -> HMSBenchmarks.benchmarkUpdatePartitionsStat(bench, bData, 1)).add("renameTable", () -> HMSBenchmarks.benchmarkRenameTable(bench, bData, 1)).add("dropDatabase", () -> HMSBenchmarks.benchmarkDropDatabase(bench, bData, 1)).add("openTxn", () -> HMSBenchmarks.benchmarkOpenTxns(bench, bData, 1)).add("PartitionManagementTask", () -> HMSBenchmarks.benchmarkPartitionManagement(bench, bData, 1));
        for (int howMany : this.instances) {
            suite.add("listTables." + howMany, () -> HMSBenchmarks.benchmarkListTables(bench, bData, howMany)).add("dropTableWithPartitions." + howMany, () -> HMSBenchmarks.benchmarkDeleteWithPartitions(bench, bData, howMany, this.nParameters[0])).add("dropTableMetaOnlyWithPartitions." + howMany, () -> HMSBenchmarks.benchmarkDeleteMetaOnlyWithPartitions(bench, bData, howMany, this.nParameters[0])).add("listPartitions." + howMany, () -> HMSBenchmarks.benchmarkListManyPartitions(bench, bData, howMany)).add("getPartitions." + howMany, () -> HMSBenchmarks.benchmarkGetPartitions(bench, bData, howMany)).add("getPartitionNames." + howMany, () -> HMSBenchmarks.benchmarkGetPartitionNames(bench, bData, howMany)).add("getPartitionsByNames." + howMany, () -> HMSBenchmarks.benchmarkGetPartitionsByName(bench, bData, howMany)).add("getPartitionsByFilter." + howMany, () -> HMSBenchmarks.benchmarkGetPartitionsByFilter(bench, bData, howMany)).add("getPartitionsByPs." + howMany, () -> HMSBenchmarks.benchmarkGetPartitionsByPs(bench, bData, howMany)).add("getPartitionsStat." + howMany, () -> HMSBenchmarks.benchmarkGetPartitionsStat(bench, bData, howMany)).add("updatePartitionsStat." + howMany, () -> HMSBenchmarks.benchmarkUpdatePartitionsStat(bench, bData, howMany)).add("addPartitions." + howMany, () -> HMSBenchmarks.benchmarkCreatePartitions(bench, bData, howMany)).add("dropPartitions." + howMany, () -> HMSBenchmarks.benchmarkDropPartitions(bench, bData, howMany)).add("alterPartitions." + howMany, () -> HMSBenchmarks.benchmarkAlterPartitions(bench, bData, howMany)).add("renameTable." + howMany, () -> HMSBenchmarks.benchmarkRenameTable(bench, bData, howMany)).add("dropDatabase." + howMany, () -> HMSBenchmarks.benchmarkDropDatabase(bench, bData, howMany)).add("addPartition." + howMany, () -> HMSBenchmarks.benchmarkCreatePartition(bench, bData, howMany)).add("dropPartition." + howMany, () -> HMSBenchmarks.benchmarkDropPartition(bench, bData, howMany)).add("openTxns." + howMany, () -> HMSBenchmarks.benchmarkOpenTxns(bench, bData, howMany)).add("PartitionManagementTask." + howMany, () -> HMSBenchmarks.benchmarkPartitionManagement(bench, bData, howMany));
        }
        List toRun = suite.listMatching(this.matches, this.exclude);
        if (toRun.isEmpty()) {
            return;
        }
        if (this.doList) {
            toRun.forEach(System.out::println);
            return;
        }
        LOG.info("Using table '{}.{}", (Object)this.dbName, (Object)this.tableName);
        try (HMSClient client = new HMSClient(Util.getServerUri((String)this.host, (String)String.valueOf(this.port)), this.confDir);){
            bData.setClient(client);
            if (!client.dbExists(this.dbName)) {
                client.createDatabase(this.dbName);
            }
            if (client.tableExists(this.dbName, this.tableName)) {
                client.dropTable(this.dbName, this.tableName);
            }
            BenchmarkSuite result = suite.runMatching(this.matches, this.exclude);
            Formatter fmt = new Formatter(sb);
            if (this.doCSV) {
                result.displayCSV(fmt, this.csvSeparator);
            } else {
                result.display(fmt);
            }
            PrintStream output = System.out;
            if (this.outputFile != null) {
                output = new PrintStream(this.outputFile);
            }
            if (this.outputFile != null) {
                StringBuilder s = new StringBuilder();
                Formatter f = new Formatter(s);
                result.display(f);
                System.out.print(s);
                f.close();
            }
            output.print(sb.toString());
            fmt.close();
            output.close();
            if (this.dataSaveDir != null) {
                BenchmarkTool.saveData(result.getResult(), this.dataSaveDir, scale);
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static enum RunModes {
        ACID,
        NONACID,
        ALL,
        MSCK;

    }
}

