/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.PathCache;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.encoded.LlapOrcCacheLoader;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LlapCacheMetadataSerializer {
    public static final Logger LOG = LoggerFactory.getLogger(LlapCacheMetadataSerializer.class);
    private final FileMetadataCache metadataCache;
    private final DataCache cache;
    private final Configuration conf;
    private final PathCache pathCache;
    private final FixedSizedObjectPool<IoTrace> tracePool;
    private final LowLevelCachePolicy cachePolicy;

    LlapCacheMetadataSerializer(FileMetadataCache fileMetadataCache, DataCache cache, Configuration daemonConf, PathCache pathCache, FixedSizedObjectPool<IoTrace> tracePool, LowLevelCachePolicy realCachePolicy) {
        this.metadataCache = fileMetadataCache;
        this.cache = cache;
        this.conf = daemonConf;
        this.pathCache = pathCache;
        this.tracePool = tracePool;
        this.cachePolicy = realCachePolicy;
    }

    public LlapDaemonProtocolProtos.CacheEntryList fetchCachedContentInfo() {
        List<LlapCacheableBuffer> buffers = this.cachePolicy.getHotBuffers();
        List<LlapDaemonProtocolProtos.CacheEntry> entries = this.encodeAndConvertHotBuffers(buffers);
        return LlapDaemonProtocolProtos.CacheEntryList.newBuilder().addAllEntries(entries).build();
    }

    private List<LlapDaemonProtocolProtos.CacheEntry> encodeAndConvertHotBuffers(List<LlapCacheableBuffer> buffers) {
        Map<Object, LlapDaemonProtocolProtos.CacheEntry.Builder> entries = this.encodeAndSortHotBuffersByFileKey(buffers);
        return entries.values().stream().map(v -> v.build()).collect(Collectors.toList());
    }

    private Map<Object, LlapDaemonProtocolProtos.CacheEntry.Builder> encodeAndSortHotBuffersByFileKey(List<LlapCacheableBuffer> buffers) {
        HashMap<Object, LlapDaemonProtocolProtos.CacheEntry.Builder> lookupMap = new HashMap<Object, LlapDaemonProtocolProtos.CacheEntry.Builder>();
        for (LlapCacheableBuffer b : buffers) {
            if (!(b instanceof LlapDataBuffer)) continue;
            LlapDataBuffer db = (LlapDataBuffer)b;
            try {
                Object fileKey = db.getFileKey();
                String path = this.pathCache.resolve(db.getFileKey());
                if (path == null) continue;
                LlapDaemonProtocolProtos.CacheEntry.Builder builder = LlapCacheMetadataSerializer.lookupOrCreateCacheEntryFromDataBuffer(lookupMap, db, fileKey, path);
                LlapDaemonProtocolProtos.CacheEntryRange.Builder range = LlapDaemonProtocolProtos.CacheEntryRange.newBuilder().setStart(db.getStart()).setEnd(db.getStart() + (long)db.declaredCachedLength);
                builder.addRanges(range);
            }
            catch (IOException ex) {
                LOG.warn("Skip buffer from CacheEntryList.", (Throwable)ex);
            }
        }
        return lookupMap;
    }

    private static LlapDaemonProtocolProtos.CacheEntry.Builder lookupOrCreateCacheEntryFromDataBuffer(Map<Object, LlapDaemonProtocolProtos.CacheEntry.Builder> lookupMap, LlapDataBuffer db, Object fileKey, String path) throws IOException {
        LlapDaemonProtocolProtos.CacheEntry.Builder builder = lookupMap.get(fileKey);
        if (builder == null) {
            ByteString encodedFileKey = LlapCacheMetadataSerializer.encodeFileKey(fileKey);
            LlapDaemonProtocolProtos.CacheTag.Builder ctb = LlapCacheMetadataSerializer.encodeCacheTag(db.getTag());
            builder = LlapDaemonProtocolProtos.CacheEntry.newBuilder().setFileKey(encodedFileKey).setCacheTag(ctb).setFilePath(path);
            lookupMap.put(fileKey, builder);
        }
        return builder;
    }

    private static LlapDaemonProtocolProtos.CacheTag.Builder encodeCacheTag(CacheTag cacheTag) {
        LlapDaemonProtocolProtos.CacheTag.Builder ctb = LlapDaemonProtocolProtos.CacheTag.newBuilder().setTableName(cacheTag.getTableName());
        if (cacheTag instanceof CacheTag.PartitionCacheTag) {
            CacheTag.PartitionCacheTag partitionCacheTag = (CacheTag.PartitionCacheTag)cacheTag;
            ctb.addAllPartitionDesc(Arrays.asList(partitionCacheTag.getEncodedPartitionDesc()));
        }
        return ctb;
    }

    public void loadData(LlapDaemonProtocolProtos.CacheEntryList data) {
        for (LlapDaemonProtocolProtos.CacheEntry ce : data.getEntriesList()) {
            try {
                this.loadData(ce);
            }
            catch (IOException ex) {
                LOG.warn("Skip cache entry load to the cache.", (Throwable)ex);
            }
        }
    }

    private void loadData(LlapDaemonProtocolProtos.CacheEntry ce) throws IOException {
        CacheTag cacheTag = LlapCacheMetadataSerializer.decodeCacheTag(ce.getCacheTag());
        DiskRangeList ranges = LlapCacheMetadataSerializer.decodeRanges(ce.getRangesList());
        Object fileKey = LlapCacheMetadataSerializer.decodeFileKey(ce.getFileKey());
        try (LlapOrcCacheLoader llr = new LlapOrcCacheLoader(new Path(ce.getFilePath()), fileKey, this.conf, this.cache, this.metadataCache, cacheTag, this.tracePool);){
            llr.init();
            llr.loadFileFooter();
            llr.loadRanges(ranges);
        }
    }

    private static DiskRangeList decodeRanges(List<LlapDaemonProtocolProtos.CacheEntryRange> ranges) {
        DiskRangeList.CreateHelper helper = new DiskRangeList.CreateHelper();
        ranges.stream().sorted(Comparator.comparing(LlapDaemonProtocolProtos.CacheEntryRange::getStart)).forEach(r -> helper.addOrMerge(r.getStart(), r.getEnd(), false, false));
        return helper.get();
    }

    private static CacheTag decodeCacheTag(LlapDaemonProtocolProtos.CacheTag ct) {
        return ct.getPartitionDescCount() == 0 ? CacheTag.build((String)ct.getTableName()) : CacheTag.build((String)ct.getTableName(), (List)ct.getPartitionDescList());
    }

    @VisibleForTesting
    static ByteString encodeFileKey(Object fileKey) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        if (fileKey instanceof SyntheticFileId) {
            SyntheticFileId fk = (SyntheticFileId)fileKey;
            fk.write((DataOutput)dos);
        } else {
            dos.writeLong((Long)fileKey);
        }
        return ByteString.copyFrom((byte[])baos.toByteArray());
    }

    @VisibleForTesting
    static Object decodeFileKey(ByteString encodedFileKey) throws IOException {
        Long fileKey;
        byte[] bytes = encodedFileKey.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        if (bytes.length == 8) {
            fileKey = in.readLong();
        } else {
            SyntheticFileId fileId = new SyntheticFileId();
            fileId.readFields((DataInput)in);
            fileKey = fileId;
        }
        return fileKey;
    }
}

