/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.llap.io.encoded.SerDeEncodedDataReader;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.ConsumerStripeMetadata;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.IoTrace;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;

public class GenericColumnVectorProducer
implements ColumnVectorProducer {
    private final SerDeLowLevelCacheImpl cache;
    private final BufferUsageManager bufferManager;
    private final Configuration conf;
    private final LlapDaemonCacheMetrics cacheMetrics;
    private final LlapDaemonIOMetrics ioMetrics;
    private final FixedSizedObjectPool<IoTrace> tracePool;
    private final ExecutorService encodeExecutor;

    public GenericColumnVectorProducer(SerDeLowLevelCacheImpl serdeCache, BufferUsageManager bufferManager, Configuration conf, LlapDaemonCacheMetrics cacheMetrics, LlapDaemonIOMetrics ioMetrics, FixedSizedObjectPool<IoTrace> tracePool, ExecutorService encodeExecutor) {
        LlapIoImpl.LOG.info("Initializing ORC column vector producer");
        this.cache = serdeCache;
        this.bufferManager = bufferManager;
        this.conf = conf;
        this.cacheMetrics = cacheMetrics;
        this.ioMetrics = ioMetrics;
        this.tracePool = tracePool;
        this.encodeExecutor = encodeExecutor;
    }

    @Override
    public ReadPipeline createReadPipeline(Consumer<ColumnVectorBatch> consumer, FileSplit split, ColumnVectorProducer.Includes includes, SearchArgument sarg, QueryFragmentCounters counters, ColumnVectorProducer.SchemaEvolutionFactory sef, InputFormat<?, ?> sourceInputFormat, Deserializer sourceSerDe, Reporter reporter, JobConf job, Map<Path, PartitionDesc> parts) throws IOException {
        SerDeFileMetadata fm;
        this.cacheMetrics.incrCacheReadRequests();
        OrcEncodedDataConsumer edc = new OrcEncodedDataConsumer(consumer, includes, counters, this.ioMetrics);
        try {
            fm = new SerDeFileMetadata(sourceSerDe);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        edc.setFileMetadata(fm);
        SerDeEncodedDataReader reader = new SerDeEncodedDataReader(this.cache, this.bufferManager, this.conf, split, includes.getPhysicalColumnIds(), edc, job, reporter, sourceInputFormat, sourceSerDe, counters, fm.getSchema(), parts, this.encodeExecutor);
        edc.init(reader, (Callable<Void>)((Object)reader), new IoTrace(0, false));
        return edc;
    }

    private static final class SerDeFileMetadata
    implements ConsumerFileMetadata {
        private final List<OrcProto.Type> orcTypes = new ArrayList<OrcProto.Type>();
        private final TypeDescription schema;

        public SerDeFileMetadata(Deserializer sourceSerDe) throws SerDeException {
            TypeDescription schema;
            this.schema = schema = OrcInputFormat.convertTypeInfo((TypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)sourceSerDe.getObjectInspector()));
            this.addTypesFromSchema(schema);
        }

        public static List<TypeDescription> setTypeBuilderFromSchema(OrcProto.Type.Builder type, TypeDescription schema) {
            List children = schema.getChildren();
            switch (schema.getCategory()) {
                case BOOLEAN: {
                    type.setKind(OrcProto.Type.Kind.BOOLEAN);
                    break;
                }
                case BYTE: {
                    type.setKind(OrcProto.Type.Kind.BYTE);
                    break;
                }
                case SHORT: {
                    type.setKind(OrcProto.Type.Kind.SHORT);
                    break;
                }
                case INT: {
                    type.setKind(OrcProto.Type.Kind.INT);
                    break;
                }
                case LONG: {
                    type.setKind(OrcProto.Type.Kind.LONG);
                    break;
                }
                case FLOAT: {
                    type.setKind(OrcProto.Type.Kind.FLOAT);
                    break;
                }
                case DOUBLE: {
                    type.setKind(OrcProto.Type.Kind.DOUBLE);
                    break;
                }
                case STRING: {
                    type.setKind(OrcProto.Type.Kind.STRING);
                    break;
                }
                case CHAR: {
                    type.setKind(OrcProto.Type.Kind.CHAR);
                    type.setMaximumLength(schema.getMaxLength());
                    break;
                }
                case VARCHAR: {
                    type.setKind(OrcProto.Type.Kind.VARCHAR);
                    type.setMaximumLength(schema.getMaxLength());
                    break;
                }
                case BINARY: {
                    type.setKind(OrcProto.Type.Kind.BINARY);
                    break;
                }
                case TIMESTAMP: {
                    type.setKind(OrcProto.Type.Kind.TIMESTAMP);
                    break;
                }
                case TIMESTAMP_INSTANT: {
                    type.setKind(OrcProto.Type.Kind.TIMESTAMP_INSTANT);
                    break;
                }
                case DATE: {
                    type.setKind(OrcProto.Type.Kind.DATE);
                    break;
                }
                case DECIMAL: {
                    type.setKind(OrcProto.Type.Kind.DECIMAL);
                    type.setPrecision(schema.getPrecision());
                    type.setScale(schema.getScale());
                    break;
                }
                case LIST: {
                    type.setKind(OrcProto.Type.Kind.LIST);
                    type.addSubtypes(((TypeDescription)children.get(0)).getId());
                    break;
                }
                case MAP: {
                    type.setKind(OrcProto.Type.Kind.MAP);
                    for (TypeDescription t : children) {
                        type.addSubtypes(t.getId());
                    }
                    break;
                }
                case STRUCT: {
                    type.setKind(OrcProto.Type.Kind.STRUCT);
                    for (TypeDescription t : children) {
                        type.addSubtypes(t.getId());
                    }
                    for (String field : schema.getFieldNames()) {
                        type.addFieldNames(field);
                    }
                    break;
                }
                case UNION: {
                    type.setKind(OrcProto.Type.Kind.UNION);
                    for (TypeDescription t : children) {
                        type.addSubtypes(t.getId());
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown category: " + schema.getCategory());
                }
            }
            return children;
        }

        private void addTypesFromSchema(TypeDescription schema) {
            OrcProto.Type.Builder type = OrcProto.Type.newBuilder();
            List<TypeDescription> children = SerDeFileMetadata.setTypeBuilderFromSchema(type, schema);
            this.orcTypes.add(type.build());
            if (children == null) {
                return;
            }
            for (TypeDescription child : children) {
                this.addTypesFromSchema(child);
            }
        }

        @Override
        public List<OrcProto.Type> getTypes() {
            return this.orcTypes;
        }

        @Override
        public int getStripeCount() {
            return 1;
        }

        @Override
        public CompressionKind getCompressionKind() {
            return CompressionKind.NONE;
        }

        @Override
        public TypeDescription getSchema() {
            return this.schema;
        }

        @Override
        public OrcFile.Version getFileVersion() {
            return null;
        }

        @Override
        public OrcProto.CalendarKind getCalendar() {
            return OrcProto.CalendarKind.JULIAN_GREGORIAN;
        }
    }

    public static final class SerDeStripeMetadata
    implements ConsumerStripeMetadata {
        private final String writerTimezone = "UTC";
        private List<OrcProto.ColumnEncoding> encodings;
        private final int stripeIx;
        private long rowCount = -1L;

        public SerDeStripeMetadata(int stripeIx) {
            this.stripeIx = stripeIx;
        }

        @Override
        public String getWriterTimezone() {
            return "UTC";
        }

        @Override
        public int getStripeIx() {
            return this.stripeIx;
        }

        @Override
        public long getRowCount() {
            return this.rowCount;
        }

        @Override
        public List<OrcProto.ColumnEncoding> getEncodings() {
            return this.encodings;
        }

        @Override
        public OrcProto.RowIndexEntry getRowIndexEntry(int colIx, int rgIx) {
            throw new UnsupportedOperationException();
        }

        public void setEncodings(List<OrcProto.ColumnEncoding> encodings) {
            this.encodings = encodings;
        }

        @Override
        public OrcProto.RowIndex[] getRowIndexes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsRowIndexes() {
            return false;
        }

        public void setRowCount(long value) {
            this.rowCount = value;
        }

        public String toString() {
            return "[stripeIx=" + this.stripeIx + ", rowCount=" + this.rowCount + ", encodings=" + this.encodings + "]".replace('\n', ' ');
        }
    }
}

