/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.decode;

import java.lang.management.ThreadMXBean;
import java.util.concurrent.Callable;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.ColumnVectorBatch;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.ReadPipeline;
import org.apache.hadoop.hive.llap.io.encoded.TezCounterSource;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.tez.common.counters.TezCounters;

public abstract class EncodedDataConsumer<BatchKey, BatchType extends EncodedColumnBatch<BatchKey>>
implements Consumer<BatchType>,
ReadPipeline {
    private volatile boolean isStopped = false;
    private ConsumerFeedback<BatchType> upstreamFeedback;
    private final Consumer<ColumnVectorBatch> downstreamConsumer;
    private Callable<Void> readCallable;
    private final LlapDaemonIOMetrics ioMetrics;
    private static final int CVB_POOL_SIZE = 128;
    protected final FixedSizedObjectPool<ColumnVectorBatch> cvbPool;
    protected final QueryFragmentCounters counters;
    private final ThreadMXBean mxBean;

    public EncodedDataConsumer(Consumer<ColumnVectorBatch> consumer, final int colCount, LlapDaemonIOMetrics ioMetrics, QueryFragmentCounters counters) {
        this.downstreamConsumer = consumer;
        this.ioMetrics = ioMetrics;
        this.mxBean = LlapUtil.initThreadMxBean();
        this.cvbPool = new FixedSizedObjectPool(128, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<ColumnVectorBatch>(){

            public ColumnVectorBatch create() {
                return new ColumnVectorBatch(colCount);
            }

            public void resetBeforeOffer(ColumnVectorBatch t) {
            }
        });
        this.counters = counters;
    }

    public void init(ConsumerFeedback<BatchType> upstreamFeedback, Callable<Void> readCallable) {
        this.upstreamFeedback = upstreamFeedback;
        this.readCallable = this.mxBean == null ? readCallable : new CpuRecordingCallable(readCallable);
    }

    @Override
    public Callable<Void> getReadCallable() {
        return this.readCallable;
    }

    public void consumeData(BatchType data) throws InterruptedException {
        if (this.isStopped) {
            this.returnSourceData(data);
            return;
        }
        long start = System.currentTimeMillis();
        try {
            this.decodeBatch(data, this.downstreamConsumer);
        }
        catch (Throwable ex) {
            LlapIoImpl.LOG.error("decodeBatch threw", ex);
            this.downstreamConsumer.setError(ex);
            throw ex;
        }
        finally {
            long end = System.currentTimeMillis();
            this.ioMetrics.addDecodeBatchTime(end - start);
        }
        this.returnSourceData(data);
    }

    private void returnSourceData(BatchType data) {
        this.upstreamFeedback.returnData(data);
    }

    protected abstract void decodeBatch(BatchType var1, Consumer<ColumnVectorBatch> var2) throws InterruptedException;

    public void setDone() throws InterruptedException {
        this.downstreamConsumer.setDone();
        this.cvbPool.clear();
    }

    public void setError(Throwable t) throws InterruptedException {
        this.downstreamConsumer.setError(t);
    }

    @Override
    public void returnData(ColumnVectorBatch data) {
        for (ColumnVector cv : data.cols) {
            if (cv == null || cv.getRef() <= 0) continue;
            return;
        }
        this.cvbPool.offer((Object)data);
    }

    @Override
    public void stop() {
        this.upstreamFeedback.stop();
        this.isStopped = true;
    }

    @Override
    public void pause() {
        this.upstreamFeedback.pause();
    }

    @Override
    public void unpause() {
        this.upstreamFeedback.unpause();
    }

    private class CpuRecordingCallable
    implements Callable<Void>,
    TezCounterSource {
        private final Callable<Void> readCallable;

        public CpuRecordingCallable(Callable<Void> readCallable) {
            this.readCallable = readCallable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (EncodedDataConsumer.this.mxBean == null) {
                return this.readCallable.call();
            }
            long cpuTime = EncodedDataConsumer.this.mxBean.getCurrentThreadCpuTime();
            long userTime = EncodedDataConsumer.this.mxBean.getCurrentThreadUserTime();
            try {
                Void void_ = this.readCallable.call();
                return void_;
            }
            finally {
                EncodedDataConsumer.this.counters.recordThreadTimes(EncodedDataConsumer.this.mxBean.getCurrentThreadCpuTime() - cpuTime, EncodedDataConsumer.this.mxBean.getCurrentThreadUserTime() - userTime);
            }
        }

        @Override
        public TezCounters getTezCounters() {
            return this.readCallable instanceof TezCounterSource ? ((TezCounterSource)((Object)this.readCallable)).getTezCounters() : null;
        }
    }
}

