/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Statistics {
    private final ConcurrentHashMap<String, TabletStatistics> stsMap = new ConcurrentHashMap();

    public long getTabletStatistic(String tabletId, Statistic statistic) {
        TabletStatistics tabletStatistics = this.stsMap.get(tabletId);
        if (tabletStatistics == null) {
            return 0L;
        }
        return tabletStatistics.getStatistic(statistic);
    }

    public long getTableStatistic(String tableName, Statistic statistic) {
        long stsResult = 0L;
        for (TabletStatistics tabletStatistics : this.stsMap.values()) {
            if (!tabletStatistics.tableName.equals(tableName)) continue;
            stsResult += tabletStatistics.getStatistic(statistic);
        }
        return stsResult;
    }

    public long getClientStatistic(Statistic statistic) {
        long stsResult = 0L;
        for (TabletStatistics tabletStatistics : this.stsMap.values()) {
            stsResult += tabletStatistics.getStatistic(statistic);
        }
        return stsResult;
    }

    public Set<String> getTabletSet() {
        HashSet<String> tablets = Sets.newHashSet();
        for (String tablet : this.stsMap.keySet()) {
            tablets.add(tablet);
        }
        return tablets;
    }

    public Set<String> getTableSet() {
        HashSet<String> tables = Sets.newHashSet();
        for (TabletStatistics tabletStat : this.stsMap.values()) {
            tables.add(tabletStat.tableName);
        }
        return tables;
    }

    public String getTableName(String tabletId) {
        TabletStatistics tabletStatistics = this.stsMap.get(tabletId);
        if (tabletStatistics == null) {
            return null;
        }
        return tabletStatistics.tableName;
    }

    TabletStatistics getTabletStatistics(String tableName, String tabletId) {
        TabletStatistics newTabletStats;
        TabletStatistics tabletStats = this.stsMap.get(tabletId);
        if (tabletStats == null && (tabletStats = this.stsMap.putIfAbsent(tabletId, newTabletStats = new TabletStatistics(tableName, tabletId))) == null) {
            tabletStats = newTabletStats;
        }
        return tabletStats;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Current client statistics: ");
        buf.append("bytes written:");
        buf.append(this.getClientStatistic(Statistic.BYTES_WRITTEN));
        buf.append(", write rpcs:");
        buf.append(this.getClientStatistic(Statistic.WRITE_RPCS));
        buf.append(", rpc errors:");
        buf.append(this.getClientStatistic(Statistic.RPC_ERRORS));
        buf.append(", write operations:");
        buf.append(this.getClientStatistic(Statistic.WRITE_OPS));
        buf.append(", operation errors:");
        buf.append(this.getClientStatistic(Statistic.OPS_ERRORS));
        return buf.toString();
    }

    static class TabletStatistics {
        private final AtomicLongArray statistics;
        private final String tableName;
        private final String tabletId;

        TabletStatistics(String tableName, String tabletId) {
            this.tableName = tableName;
            this.tabletId = tabletId;
            this.statistics = new AtomicLongArray(Statistic.values().length);
        }

        void incrementStatistic(Statistic statistic, long count) {
            this.statistics.addAndGet(statistic.getIndex(), count);
        }

        long getStatistic(Statistic statistic) {
            return this.statistics.get(statistic.getIndex());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Table: ");
            buf.append(this.tableName);
            buf.append(", tablet:");
            buf.append(this.tabletId);
            buf.append(", bytes written:");
            buf.append(this.getStatistic(Statistic.BYTES_WRITTEN));
            buf.append(", write rpcs:");
            buf.append(this.getStatistic(Statistic.WRITE_RPCS));
            buf.append(", rpc errors:");
            buf.append(this.getStatistic(Statistic.RPC_ERRORS));
            buf.append(", write operations:");
            buf.append(this.getStatistic(Statistic.WRITE_OPS));
            buf.append(", operation errors:");
            buf.append(this.getStatistic(Statistic.OPS_ERRORS));
            return buf.toString();
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum Statistic {
        BYTES_WRITTEN(0),
        WRITE_OPS(1),
        WRITE_RPCS(2),
        OPS_ERRORS(3),
        RPC_ERRORS(4);

        private final int idx;

        private Statistic(int idx) {
            this.idx = idx;
        }

        int getIndex() {
            return this.idx;
        }
    }
}

