/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kudu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.kudu.KuduHiveUtils;
import org.apache.hadoop.hive.kudu.KuduWritable;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hive.kudu.org.apache.kudu.client.KuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.KuduSession;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.RowError;
import org.apache.hive.kudu.org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.hive.kudu.org.apache.kudu.client.SessionConfiguration;
import org.apache.hive.kudu.org.apache.kudu.client.Upsert;

public class KuduOutputFormat
extends OutputFormat<NullWritable, KuduWritable>
implements HiveOutputFormat<NullWritable, KuduWritable> {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        return new KuduRecordWriter(KuduHiveUtils.createOverlayedConf((Configuration)jc, tableProperties));
    }

    public RecordWriter<NullWritable, KuduWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        return new KuduRecordWriter((Configuration)job);
    }

    public org.apache.hadoop.mapreduce.RecordWriter<NullWritable, KuduWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        return new KuduRecordWriter(context.getConfiguration());
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) {
    }

    public void checkOutputSpecs(JobContext context) {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new KuduOuputComitter();
    }

    static class KuduRecordWriter
    extends org.apache.hadoop.mapreduce.RecordWriter<NullWritable, KuduWritable>
    implements FileSinkOperator.RecordWriter,
    RecordWriter<NullWritable, KuduWritable> {
        private KuduClient client;
        private KuduTable table;
        private KuduSession session;

        KuduRecordWriter(Configuration conf) throws IOException {
            this.client = KuduHiveUtils.getKuduClient(conf);
            String tableName = conf.get("kudu.table_name");
            if (StringUtils.isEmpty((CharSequence)tableName)) {
                throw new IllegalArgumentException("kudu.table_name is not set.");
            }
            if (!this.client.tableExists(tableName)) {
                throw new IllegalArgumentException("Kudu table does not exist: " + tableName);
            }
            this.table = this.client.openTable(tableName);
            this.session = this.client.newSession();
            this.session.setFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND);
        }

        public void write(Writable row) throws IOException {
            Preconditions.checkArgument((boolean)(row instanceof KuduWritable));
            Upsert op = this.table.newUpsert();
            ((KuduWritable)row).populateRow(op.getRow());
            this.session.apply(op);
        }

        public void write(NullWritable key, KuduWritable value) throws IOException {
            this.write(value);
        }

        public void close(boolean abort) throws IOException {
            this.session.close();
            this.processErrors();
            this.client.close();
        }

        public void close(TaskAttemptContext context) throws IOException {
            this.close(false);
        }

        public void close(Reporter reporter) throws IOException {
            this.close(false);
        }

        private void processErrors() throws IOException {
            RowErrorsAndOverflowStatus pendingErrors = this.session.getPendingErrors();
            if (pendingErrors.getRowErrors().length != 0) {
                RowError[] errors = pendingErrors.getRowErrors();
                int sampleSize = 5;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < errors.length && i != sampleSize; ++i) {
                    sb.append(errors[i].getErrorStatus().toString());
                }
                if (pendingErrors.isOverflowed()) {
                    throw new IOException("PendingErrors overflowed. Failed to write at least " + errors.length + " rows to Kudu; Sample errors: " + sb.toString());
                }
                throw new IOException("Failed to write " + errors.length + " rows to Kudu; Sample errors: " + sb.toString());
            }
        }
    }

    static class KuduOuputComitter
    extends OutputCommitter {
        KuduOuputComitter() {
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskAttemptContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) {
            return false;
        }

        public void commitTask(TaskAttemptContext taskAttemptContext) {
        }

        public void abortTask(TaskAttemptContext taskAttemptContext) {
        }
    }
}

