/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kudu;

import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.kudu.org.apache.kudu.ColumnTypeAttributes;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.KuduClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KuduHiveUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KuduHiveUtils.class);
    private static final Text KUDU_TOKEN_KIND = new Text("kudu-authn-data");

    private KuduHiveUtils() {
    }

    public static Configuration createOverlayedConf(Configuration conf, Properties tblProps) {
        Configuration newConf = new Configuration(conf);
        for (Map.Entry<Object, Object> prop : tblProps.entrySet()) {
            newConf.set((String)prop.getKey(), (String)prop.getValue());
        }
        return newConf;
    }

    public static String getMasterAddresses(Configuration conf) throws IOException {
        String masterAddresses = conf.get("kudu.master_addresses");
        if (StringUtils.isEmpty((CharSequence)masterAddresses)) {
            masterAddresses = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_KUDU_MASTER_ADDRESSES_DEFAULT);
        }
        if (StringUtils.isEmpty((CharSequence)masterAddresses)) {
            throw new IOException("Kudu master addresses are not specified in the table property (kudu.master_addresses), or default configuration (" + HiveConf.ConfVars.HIVE_KUDU_MASTER_ADDRESSES_DEFAULT.varname + ").");
        }
        return masterAddresses;
    }

    public static KuduClient getKuduClient(Configuration conf) throws IOException {
        String masterAddresses = KuduHiveUtils.getMasterAddresses(conf);
        KuduClient client = new KuduClient.KuduClientBuilder(masterAddresses).build();
        KuduHiveUtils.importCredentialsFromCurrentSubject(client);
        return client;
    }

    public static void importCredentialsFromCurrentSubject(KuduClient client) {
        Subject subj = Subject.getSubject(AccessController.getContext());
        if (subj == null) {
            return;
        }
        Text service = new Text(client.getMasterAddressesAsString());
        Set<Credentials> credSet = subj.getPrivateCredentials(Credentials.class);
        for (Credentials creds : credSet) {
            for (Token tok : creds.getAllTokens()) {
                if (!tok.getKind().equals((Object)KUDU_TOKEN_KIND)) continue;
                if (!tok.getService().equals((Object)service)) {
                    LOG.debug("Not importing credentials for service " + service + "(expecting service " + service + ")");
                    continue;
                }
                LOG.debug("Importing credentials for service " + service);
                client.importAuthenticationCredentials(tok.getPassword());
                return;
            }
        }
    }

    public static PrimitiveTypeInfo toHiveType(Type kuduType, ColumnTypeAttributes attributes) throws SerDeException {
        switch (kuduType) {
            case BOOL: {
                return TypeInfoFactory.booleanTypeInfo;
            }
            case INT8: {
                return TypeInfoFactory.byteTypeInfo;
            }
            case INT16: {
                return TypeInfoFactory.shortTypeInfo;
            }
            case INT32: {
                return TypeInfoFactory.intTypeInfo;
            }
            case INT64: {
                return TypeInfoFactory.longTypeInfo;
            }
            case UNIXTIME_MICROS: {
                return TypeInfoFactory.timestampTypeInfo;
            }
            case DECIMAL: {
                return TypeInfoFactory.getDecimalTypeInfo((int)attributes.getPrecision(), (int)attributes.getScale());
            }
            case FLOAT: {
                return TypeInfoFactory.floatTypeInfo;
            }
            case DOUBLE: {
                return TypeInfoFactory.doubleTypeInfo;
            }
            case STRING: {
                return TypeInfoFactory.stringTypeInfo;
            }
            case BINARY: {
                return TypeInfoFactory.binaryTypeInfo;
            }
        }
        throw new SerDeException("Unsupported column type: " + kuduType);
    }
}

