/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class JdbcInputSplit
extends FileSplit
implements InputSplit {
    private static final String[] EMPTY_ARRAY = new String[0];
    private int limit = 0;
    private int offset = 0;
    private String partitionColumn = null;
    private String lowerBound = null;
    private String upperBound = null;

    public JdbcInputSplit() {
        super(null, 0L, 0L, EMPTY_ARRAY);
        this.limit = -1;
        this.offset = 0;
    }

    public JdbcInputSplit(Path dummyPath) {
        super(dummyPath, 0L, 0L, EMPTY_ARRAY);
        this.limit = -1;
        this.offset = 0;
    }

    public JdbcInputSplit(int limit, int offset, Path dummyPath) {
        super(dummyPath, 0L, 0L, EMPTY_ARRAY);
        this.limit = limit;
        this.offset = offset;
    }

    public JdbcInputSplit(String partitionColumn, String lowerBound, String upperBound, Path dummyPath) {
        super(dummyPath, 0L, 0L, EMPTY_ARRAY);
        this.partitionColumn = partitionColumn;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.limit);
        out.writeInt(this.offset);
        if (this.partitionColumn != null) {
            out.writeBoolean(true);
            out.writeUTF(this.partitionColumn);
        } else {
            out.writeBoolean(false);
        }
        if (this.lowerBound != null) {
            out.writeBoolean(true);
            out.writeUTF(this.lowerBound);
        } else {
            out.writeBoolean(false);
        }
        if (this.upperBound != null) {
            out.writeBoolean(true);
            out.writeUTF(this.upperBound);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        boolean upperBoundExists;
        boolean lowerBoundExists;
        super.readFields(in);
        this.limit = in.readInt();
        this.offset = in.readInt();
        boolean partitionColumnExists = in.readBoolean();
        if (partitionColumnExists) {
            this.partitionColumn = in.readUTF();
        }
        if (lowerBoundExists = in.readBoolean()) {
            this.lowerBound = in.readUTF();
        }
        if (upperBoundExists = in.readBoolean()) {
            this.upperBound = in.readUTF();
        }
    }

    public long getLength() {
        return this.limit;
    }

    public String[] getLocations() throws IOException {
        return EMPTY_ARRAY;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getPartitionColumn() {
        return this.partitionColumn;
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.partitionColumn != null) {
            sb.append("interval:");
            sb.append(this.partitionColumn).append("[");
            if (this.lowerBound != null) {
                sb.append(this.lowerBound);
            }
            sb.append(",");
            if (this.upperBound != null) {
                sb.append(this.upperBound);
            }
            sb.append(")");
        } else {
            sb.append("limit:" + this.limit + ", offset:" + this.offset);
        }
        return sb.toString();
    }
}

