/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.Base64;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hive.hbase.HBaseSplit;
import org.apache.hadoop.hive.hbase.HiveHBaseInputFormatUtil;
import org.apache.hadoop.hive.hbase.ResultWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class HiveHBaseTableSnapshotInputFormat
implements InputFormat<ImmutableBytesWritable, ResultWritable> {
    TableSnapshotInputFormat delegate = new TableSnapshotInputFormat();

    private static void setColumns(JobConf job) throws IOException {
        Scan scan = HiveHBaseInputFormatUtil.getScan(job);
        job.set("hbase.mapreduce.scan", HiveHBaseTableSnapshotInputFormat.convertScanToString(scan));
    }

    static String convertScanToString(Scan scan) throws IOException {
        ClientProtos.Scan proto = ProtobufUtil.toScan((Scan)scan);
        return Base64.getEncoder().encodeToString(proto.toByteArray());
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        HiveHBaseTableSnapshotInputFormat.setColumns(job);
        Path[] tablePaths = FileInputFormat.getInputPaths((JobConf)job);
        InputSplit[] results = this.delegate.getSplits(job, numSplits);
        for (int i = 0; i < results.length; ++i) {
            results[i] = new HBaseSplit(results[i], tablePaths[0]);
        }
        return results;
    }

    public RecordReader<ImmutableBytesWritable, ResultWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        HiveHBaseTableSnapshotInputFormat.setColumns(job);
        final RecordReader rr = this.delegate.getRecordReader(((HBaseSplit)split).getSnapshotSplit(), job, reporter);
        return new RecordReader<ImmutableBytesWritable, ResultWritable>(){

            public boolean next(ImmutableBytesWritable key, ResultWritable value) throws IOException {
                return rr.next((Object)key, (Object)value.getResult());
            }

            public ImmutableBytesWritable createKey() {
                return (ImmutableBytesWritable)rr.createKey();
            }

            public ResultWritable createValue() {
                return new ResultWritable((Result)rr.createValue());
            }

            public long getPos() throws IOException {
                return rr.getPos();
            }

            public void close() throws IOException {
                rr.close();
            }

            public float getProgress() throws IOException {
                return rr.getProgress();
            }
        };
    }
}

