/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorAppMasterEventDesc;
import org.apache.hadoop.io.DataOutputBuffer;

@Explain(displayName="Application Master Event Operator")
public class AppMasterEventDesc
extends AbstractOperatorDesc {
    private TableDesc table;
    private String vertexName;
    private String inputName;

    @Explain(displayName="Target Vertex")
    @Signature
    public String getVertexName() {
        return this.vertexName;
    }

    @Explain(displayName="Target Input")
    @Signature
    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public void setVertexName(String vertexName) {
        this.vertexName = vertexName;
    }

    @Signature
    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    public void writeEventHeader(DataOutputBuffer buffer) throws IOException {
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="App Master Event Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public AppMasterEventOperatorExplainVectorization getAppMasterEventVectorization() {
        VectorAppMasterEventDesc vectorAppMasterEventDesc = (VectorAppMasterEventDesc)this.getVectorDesc();
        if (vectorAppMasterEventDesc == null) {
            return null;
        }
        return new AppMasterEventOperatorExplainVectorization(this, vectorAppMasterEventDesc);
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            AppMasterEventDesc otherDesc = (AppMasterEventDesc)other;
            return Objects.equals(this.getInputName(), otherDesc.getInputName()) && Objects.equals(this.getVertexName(), otherDesc.getVertexName()) && Objects.equals(this.getTable(), otherDesc.getTable());
        }
        return false;
    }

    public class AppMasterEventOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final AppMasterEventDesc appMasterEventDesc;
        private final VectorAppMasterEventDesc vectorAppMasterEventDesc;

        public AppMasterEventOperatorExplainVectorization(AppMasterEventDesc appMasterEventDesc, VectorAppMasterEventDesc vectorAppMasterEventDesc) {
            super(vectorAppMasterEventDesc, true);
            this.appMasterEventDesc = appMasterEventDesc;
            this.vectorAppMasterEventDesc = vectorAppMasterEventDesc;
        }
    }
}

